<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('owner_ledger_entries', function (Blueprint $table): void {
            if (! Schema::hasColumn('owner_ledger_entries', 'owner_share_cents')) {
                $table->bigInteger('owner_share_cents')
                    ->nullable()
                    ->after('amount_cents')
                    ->comment('Explicit owner share in cents; if null, derive from vehicle.owner_share_percent');
            }
        });
    }

    public function down(): void
    {
        Schema::table('owner_ledger_entries', function (Blueprint $table): void {
            if (Schema::hasColumn('owner_ledger_entries', 'owner_share_cents')) {
                $table->dropColumn('owner_share_cents');
            }
        });
    }
};
