<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('owners', function (Blueprint $table) {
            if (! Schema::hasColumn('owners', 'legal_name')) {
                $table->string('legal_name')->nullable()->after('name');
            }

            if (! Schema::hasColumn('owners', 'bank_account_name')) {
                $table->string('bank_account_name')->nullable()->after('email');
            }

            if (! Schema::hasColumn('owners', 'bank_account_number')) {
                $table->string('bank_account_number')->nullable()->after('bank_account_name');
            }

            if (! Schema::hasColumn('owners', 'bank_reference')) {
                $table->string('bank_reference')->nullable()->after('bank_account_number');
            }

            if (! Schema::hasColumn('owners', 'payout_schedule')) {
                $table->enum('payout_schedule', ['weekly', 'fortnightly', 'monthly', 'ad-hoc'])
                    ->default('ad-hoc')
                    ->after('bank_reference');
            }

            if (! Schema::hasColumn('owners', 'cc_email')) {
                $table->string('cc_email')->nullable()->after('payout_schedule');
            }

            if (! Schema::hasColumn('owners', 'gst_registered')) {
                $table->boolean('gst_registered')
                    ->default(false)
                    ->after('cc_email');
            }

            if (! Schema::hasColumn('owners', 'gst_number')) {
                $table->string('gst_number')->nullable()->after('gst_registered');
            }
        });
    }

    public function down(): void
    {
        Schema::table('owners', function (Blueprint $table) {
            if (Schema::hasColumn('owners', 'legal_name')) {
                $table->dropColumn('legal_name');
            }
            if (Schema::hasColumn('owners', 'bank_account_name')) {
                $table->dropColumn('bank_account_name');
            }
            if (Schema::hasColumn('owners', 'bank_account_number')) {
                $table->dropColumn('bank_account_number');
            }
            if (Schema::hasColumn('owners', 'bank_reference')) {
                $table->dropColumn('bank_reference');
            }
            if (Schema::hasColumn('owners', 'payout_schedule')) {
                $table->dropColumn('payout_schedule');
            }
            if (Schema::hasColumn('owners', 'cc_email')) {
                $table->dropColumn('cc_email');
            }
            if (Schema::hasColumn('owners', 'gst_registered')) {
                $table->dropColumn('gst_registered');
            }
            if (Schema::hasColumn('owners', 'gst_number')) {
                $table->dropColumn('gst_number');
            }
        });
    }
};
