import { useState } from 'react';
import axios from 'axios';

export default function ImportReservationButton({ value, onImported, disabled }) {
  const [loading, setLoading] = useState(false);

  const handleImport = async () => {
    if (!value) return;
    setLoading(true);
    try {
      const { data } = await axios.post(route('jobs.importReservation'), {
        external_reference: value,
      });
      onImported?.(data.booking);
    } catch (e) {
      const msg = e?.response?.data?.message || 'Reservation not found.';
      alert(msg);
    } finally {
      setLoading(false);
    }
  };

  return (
    <button
      type="button"
      onClick={handleImport}
      disabled={disabled || loading}
      className="bg-blue-600 text-white px-3 py-2 rounded-md disabled:opacity-50"
    >
      {loading ? 'Importing…' : 'Import'}
    </button>
  );
}
