@extends('layouts.admin')

@section('content')
<div class="max-w-2xl mx-auto py-8">
    <h1 class="text-xl font-semibold mb-4">Payment Links for Booking #{{ $booking->id }}</h1>

    <div class="space-y-6">
        <div>
            <h2 class="font-medium text-slate-700 mb-2">All-in-one Payment Page</h2>
            <input type="text" readonly class="w-full border rounded px-3 py-2 text-sm" value="{{ $url }}" id="url-main">
            <button onclick="copyToClipboard('url-main')" class="mt-2 px-4 py-2 bg-indigo-600 text-white rounded hover:bg-indigo-700">Copy Link</button>
        </div>

        <div>
            <h2 class="font-medium text-slate-700 mb-2">Bond Hold Page</h2>
            <input type="text" readonly class="w-full border rounded px-3 py-2 text-sm" value="{{ $hold }}" id="url-hold">
            <button onclick="copyToClipboard('url-hold')" class="mt-2 px-4 py-2 bg-yellow-600 text-white rounded hover:bg-yellow-700">Copy Link</button>
        </div>
    </div>
</div>

<script>
function copyToClipboard(id) {
    const el = document.getElementById(id);
    el.select();
    document.execCommand("copy");
    alert("Copied: " + el.value);
}
</script>
@endsection
