@extends('layouts.app') {{-- or your layout --}}

@section('content')
<div class="max-w-md mx-auto my-16 p-6 rounded-2xl shadow">
  <h1 class="text-2xl font-semibold mb-6">Sign in</h1>

  @if ($errors->any())
    <div class="mb-4 text-red-600">
      <ul class="list-disc list-inside text-sm">
        @foreach ($errors->all() as $error)
          <li>{{ $error }}</li>
        @endforeach
      </ul>
    </div>
  @endif

  <form method="POST" action="{{ route('login.classic.store') }}">
    @csrf
    <label class="block mb-3">
      <span class="text-sm">Email</span>
      <input name="email" type="email" value="{{ old('email') }}"
             required autofocus class="w-full border rounded px-3 py-2">
    </label>

    <label class="block mb-4">
      <span class="text-sm">Password</span>
      <input name="password" type="password" required class="w-full border rounded px-3 py-2">
    </label>

    <label class="inline-flex items-center mb-6">
      <input type="checkbox" name="remember" class="mr-2">
      <span class="text-sm">Remember me</span>
    </label>

    <button type="submit" class="w-full px-4 py-2 rounded bg-black text-white">
      Sign in
    </button>
  </form>
</div>
@endsection
