@props([
  'subject' => null,
  'preheader' => null,
  'logoUrl' => null,
  'colors' => [],
  'payUrl' => null,
])

@php
  $c = array_merge([
    'bg' => '#f9fafb',
    'card' => '#ffffff',
    'text' => '#111111',
    'muted' => '#6b7280',
    'border' => '#e5e7eb',
    'primary' => '#16a34a',
    'link' => '#2563eb',
  ], $colors ?? []);
@endphp

<!doctype html>
<html>
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    @if($preheader)
      <!-- Preheader Text -->
      <span style="display:none!important;visibility:hidden;opacity:0;color:transparent;height:0;width:0;overflow:hidden">
        {{ $preheader }}
      </span>
    @endif
  </head>
  <body style="margin:0;padding:0;background:{{ $c['bg'] }};color:{{ $c['text'] }};font-family: -apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Helvetica,Arial,sans-serif;">
    <table role="presentation" width="100%" cellpadding="0" cellspacing="0" style="background:{{ $c['bg'] }};padding:24px 0;">
      <tr>
        <td align="center">
          <table role="presentation" width="640" cellpadding="0" cellspacing="0" style="width:640px;max-width:640px;background:{{ $c['card'] }};border:1px solid {{ $c['border'] }};border-radius:12px;overflow:hidden">
            <tr>
  <td style="padding:20px 24px; text-align:left;">
    <img src="https://payments.dreamdrives.co.nz/branding/logo.png"
         alt="Dream Drives"
         style="height:75px;vertical-align:middle;display:block;">
  </td>
</tr>
            <tr>
              <td style="padding:0 24px 24px 24px;">
                {{ $slot }}
              </td>
            </tr>
            <tr>
              <td style="padding:16px 24px;color:{{ $c['muted'] }};font-size:12px;border-top:1px solid {{ $c['border'] }}">
                If you weren’t expecting this, please ignore this email.
              </td>
            </tr>
          </table>
        </td>
      </tr>
    </table>
  </body>
</html>
