@php
  $brand   = config('brand.name');
  $colors  = config('brand.colors');
  $title   = 'Secure Payment Request';
  $subject = $subject ?? "Your {$brand} payment link for {$reference}";
  $preheader = "Complete payment for reservation {$reference}.";
@endphp

<x-email.base :subject="$subject" :preheader="$preheader" :logoUrl="$logoUrl" :colors="$colors" :payUrl="$payUrl">
  <h1 style="font-size:22px;font-weight:600;margin:0 0 12px">{{ $title }}</h1>

  <p style="font-size:16px;margin:0 0 18px">
    Hi {{ $job->customer_name ?? 'there' }},<br><br>
    Please complete payment for reservation <strong>{{ $reference }}</strong>
    to secure your booking.
  </p>

@include('emails.partials.button', [
  'url'   => $payUrl,
  'label' => 'Pay now',
  'bg'    => $colors['primary'] ?? '#16a34a',
])


  <hr style="border:0;border-top:1px solid {{ $colors['border'] }};margin:12px 0 16px">

  <h2 style="font-size:16px;font-weight:600;margin:0 0 8px">Reservation Summary</h2>

  <x-email.kv label="Reservation reference" :value="$reference" />
  @if($job->customer_name)   <x-email.kv label="Name"  :value="$job->customer_name" /> @endif
  @if($job->customer_email)  <x-email.kv label="Email" :value="$job->customer_email" /> @endif
  @if($job->customer_phone)  <x-email.kv label="Phone" :value="$job->customer_phone" /> @endif
  @if($job->start_at)        <x-email.kv label="Start" :value="$job->start_at->timezone('UTC')->format('D j M Y, H:i (UTC)')" /> @endif
  @if($job->end_at)          <x-email.kv label="End"   :value="$job->end_at->timezone('UTC')->format('D j M Y, H:i (UTC)')" /> @endif

  @if(!empty($note))
    <p style="margin:16px 0 0;white-space:pre-line">{{ $note }}</p>
  @endif
</x-email.base>
