<!doctype html>
<html>
<head>
<meta charset="utf-8">
<title>Payment receipt</title>
<style>
  body{margin:0;padding:24px;background:#fafafa;font-family:-apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,Helvetica,Arial,sans-serif;color:#111}
  .wrap{max-width:680px;margin:0 auto}
  .box{background:#fff;border:1px solid #e5e7eb;border-radius:12px;overflow:hidden}
  .brand{padding:16px 24px;border-bottom:1px solid #e5e7eb;background:#fafafa}
  .brand strong{font-weight:600}
  .content{padding:24px}
  h1{margin:0 0 12px;font-size:22px;line-height:1.3}
  .muted{color:#6b7280;margin:2px 0 18px}
  .row{display:flex;gap:12px;align-items:center;margin:10px 0}
  .label{width:150px;color:#6b7280;font-size:13px}
  .value{font-size:15px}
  .total .value{font-size:24px;font-weight:700;letter-spacing:.2px}
  code{background:#f6f8fa;border:1px solid #e5e7eb;border-radius:6px;padding:3px 6px;font-family:ui-monospace,SFMono-Regular,Menlo,Consolas,"Liberation Mono",monospace}
  .footer{padding:16px 24px;border-top:1px solid #e5e7eb;background:#fafafa;color:#6b7280;font-size:12px;text-align:center}
</style>
</head>
<body>
<div class="wrap">
  <div class="box">
    <div class="brand"><strong>{{ config('app.name', 'Dream Drives') }}</strong></div>
    <div class="content">
      <h1>Payment receipt</h1>

      @php
        // Amount + currency (robust)
        $amountCents = isset($amountCents) ? (int) $amountCents : (int) ($payment->amount_cents ?? $payment->amount ?? 0);
        $code        = strtoupper($currency ?? $payment->currency ?? $job->currency ?? 'NZD');
        $symbols     = ['NZD'=>'NZ$', 'USD'=>'$', 'AUD'=>'A$', 'EUR'=>'€', 'GBP'=>'£', 'CAD'=>'C$'];
        $sym         = $symbols[$code] ?? $code;
        $formatted   = number_format($amountCents / 100, 2);

        // Date formatter
        $fmtDate = function($v) {
          try {
            if ($v instanceof \Carbon\Carbon || $v instanceof \Illuminate\Support\Carbon) {
              $c = $v;
            } else {
              $c = \Carbon\Carbon::parse($v);
            }
            return $c->format('D d M Y, h:ia');
          } catch (\Throwable $e) { return $v ?: null; }
        };

        $startText = isset($startAt) ? $fmtDate($startAt) : null;
        $endText   = isset($endAt)   ? $fmtDate($endAt)   : null;
      @endphp>

      <div class="row total">
        <div class="label">Amount:</div>
        <div class="value">{{ $sym }} {{ $formatted }} <span style="font-weight:600;color:#6b7280;font-size:14px">{{ $code }}</span></div>
      </div>

      @if(!empty($bookingRef))
        <div class="row"><div class="label">Booking reference:</div><div class="value"><code>{{ $bookingRef }}</code></div></div>
      @endif

      @if($startText || $endText)
        <div class="row">
          <div class="label">Hire dates:</div>
          <div class="value">
            @if($startText && $endText)
              {{ $startText }} &nbsp;–&nbsp; {{ $endText }}
            @elseif($startText)
              {{ $startText }}
            @elseif($endText)
              {{ $endText }}
            @endif
          </div>
        </div>
      @endif

      @if(!empty($payment?->reference))
        <div class="row"><div class="label">Reference:</div><div class="value"><code>{{ $payment->reference }}</code></div></div>
      @endif

      @if(!empty($payment?->stripe_charge ?? $payment?->stripe_charge_id))
        <div class="row"><div class="label">Charge:</div><div class="value"><code>{{ $payment->stripe_charge ?? $payment->stripe_charge_id }}</code></div></div>
      @endif

      @if(!empty($job?->customer_name))
        <div class="row"><div class="label">Customer:</div><div class="value">{{ $job->customer_name }}</div></div>
      @endif

      <p class="muted" style="margin-top:18px">Thank you for your payment.</p>
    </div>

    <div class="footer">
      Questions? Just reply to this email if you have any questions.
    </div>
  </div>
</div>
</body>
</html>
