<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>Secure payment request</title>
<style>
  /* Basic email-safe styling */
  body{margin:0;background:#f6f7fb;font-family:-apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,Helvetica,Arial,sans-serif;color:#0f172a}
  .wrap{max-width:680px;margin:0 auto;padding:24px}
  .card{background:#fff;border:1px solid #e5e7eb;border-radius:12px;overflow:hidden}
  .brand{padding:18px 22px;border-bottom:1px solid #e5e7eb;background:#fafafa;text-align:left}
  .brand img{max-height:36px;vertical-align:middle}
  .content{padding:26px}
  h1{margin:0 0 12px;font-size:22px;line-height:1.3}
  p{margin:0 0 12px}
  .muted{color:#6b7280}
  .btn{display:inline-block;background:#16a34a;color:#fff;text-decoration:none;font-weight:700;padding:11px 18px;border-radius:8px}
  .summary{margin-top:18px;border-top:1px solid #e5e7eb;padding-top:16px}
  .row{display:flex;gap:10px;margin:8px 0}
  .label{width:210px;min-width:210px;color:#64748b}
  .value{flex:1}
  .code{background:#f8fafc;border:1px solid #e2e8f0;border-radius:6px;padding:2px 6px;font-family:ui-monospace,SFMono-Regular,Menlo,Consolas,monospace}
  .footer{padding:14px 22px;border-top:1px solid #e5e7eb;background:#fafafa;color:#6b7280;font-size:12px;text-align:center}
  @media (max-width:560px){
    .wrap{padding:12px}
    .content{padding:18px}
    .label{width:140px;min-width:140px}
  }
</style>
</head>
<body>
@php
    /** Safe defaults (all optional vars guarded) */
    $purpose        = $purpose        ?? null;
    $brand          = $brand          ?? null;
    $amountCents    = isset($amountCents) ? (int)$amountCents : null;
    $holdCents      = isset($holdCents)   ? (int)$holdCents   : null;
    $invoiceNumber  = $invoiceNumber  ?? null;
    $invoiceUrl     = $invoiceUrl     ?? null;
    $payUrl         = isset($payUrl) ? (string)$payUrl : '#';

    // Brand / logo
    $brandName = $brand?->short_name ?? 'Jimny NZ / Dream Drives';
    $logo      = $brand?->email_logo_url ?? null;

    // Currency + formatting
    $ccy = strtoupper($job?->currency ?? 'NZD');
    $symbols = ['NZD'=>'NZ$','AUD'=>'A$','USD'=>'$','GBP'=>'£','EUR'=>'€','CAD'=>'C$'];
    $sym = $symbols[$ccy] ?? $ccy;
    $fmt = fn ($c) => $sym . number_format(((int)$c)/100, 2);

    // Labels / identifiers
    $label = !empty($purpose) ? ucfirst((string)$purpose) : 'Payment';
    $ref   = $job?->external_reference ?? ($job?->id ? ('#'.$job->id) : '—');
    $name  = trim((string)($job?->customer_name ?? 'there'));

    // Dates
    $formatDt = function($v, $format='D d M Y, H:i'){
        try {
            if ($v instanceof \Illuminate\Support\Carbon || $v instanceof \Carbon\Carbon) return $v->format($format);
            return $v ? \Carbon\Carbon::parse($v)->format($format) : null;
        } catch (\Throwable $e) { return null; }
    };
    $startTxt = $formatDt($job?->start_at);
    $endTxt   = $formatDt($job?->end_at);

    // Determine hold (only show if > 0)
    if ($holdCents === null) {
        $holdCents = (int)(
            optional($job?->deposit)->authorized_cents
            ?? ($job->hold_amount_cents_from_flow ?? optional($job?->flow)->hold_amount_cents ?? 0)
        );
    }
@endphp

<div class="wrap">
  <div class="card">
    <div class="brand">
      @if($logo)
        <img src="{{ $logo }}" alt="{{ $brandName }}">
      @else
        <strong>{{ $brandName }}</strong>
      @endif
    </div>

    <div class="content">
      <h1>Secure {{ strtolower($label) }}</h1>

      <p>Hi {{ $name }},</p>
      <p>
        We’ve set up a secure payment link for your booking
        <strong class="code">{{ $ref }}</strong> with <strong>{{ $brandName }}</strong>.
      </p>

      @if(isset($amountCents))
        <p>Please pay <strong>{{ $fmt($amountCents) }}</strong> to confirm your reservation.</p>
      @else
        <p>Please follow the link below to complete payment.</p>
      @endif

      <p style="margin:16px 0 10px">
        <a href="{{ $payUrl }}"
   style="background:#16a34a;border-radius:8px;color:#ffffff !important;
          display:inline-block;font-weight:700;line-height:44px;text-align:center;
          text-decoration:none !important;padding:0 18px;">
  Pay now
</a>
      </p>

      <p class="muted" style="font-size:13px">
        If the button doesn’t work, copy and paste this link:<br>
        <span style="word-break:break-all">{{ $payUrl }}</span>
      </p>

      <div class="summary">
        <h2 style="margin:0 0 10px;font-size:16px">Reservation Summary</h2>

        <div class="row">
          <div class="label">Reservation reference</div>
          <div class="value"><span class="code">{{ $ref }}</span></div>
        </div>

        <div class="row">
          <div class="label">Name</div>
          <div class="value">{{ $job?->customer_name ?? '—' }}</div>
        </div>

        <div class="row">
          <div class="label">Email</div>
          <div class="value">
            @if(!empty($job?->customer_email))
              <a href="mailto:{{ $job->customer_email }}">{{ $job->customer_email }}</a>
            @else
              —
            @endif
          </div>
        </div>

        <div class="row">
          <div class="label">Phone</div>
          <div class="value">{{ $job?->customer_phone ?? '—' }}</div>
        </div>

        @if($startTxt || $endTxt)
        <div class="row">
          <div class="label">Start</div>
          <div class="value">{{ $startTxt ?? '—' }}</div>
        </div>
        <div class="row">
          <div class="label">End</div>
          <div class="value">{{ $endTxt ?? '—' }}</div>
        </div>
        @endif

        @if(isset($amountCents))
        <div class="row">
          <div class="label">Amount due</div>
          <div class="value">{{ $fmt($amountCents) }} <span class="muted">({{ $ccy }})</span></div>
        </div>
        @endif

        @if(!empty($invoiceNumber) || !empty($invoiceUrl))
        <div class="row">
          <div class="label">Invoice</div>
          <div class="value">
            @if(!empty($invoiceNumber)) {{ $invoiceNumber }} @endif
            @if(!empty($invoiceNumber) && !empty($invoiceUrl)) &nbsp;—&nbsp; @endif
            @if(!empty($invoiceUrl)) <a href="{{ $invoiceUrl }}">View online</a> @endif
          </div>
        </div>
        @endif
      </div>

      @if(($holdCents ?? 0) > 0)
      <div style="margin-top:16px;padding:12px;border:1px solid #e5e7eb;border-radius:10px;background:#f9fafb">
        <strong>About the refundable security hold</strong>
        <p class="muted" style="margin:6px 0 0;font-size:14px">
          A refundable security hold of <strong>{{ $fmt($holdCents) }}</strong> may appear as
          <em>“pending”</em> on your card. It isn’t a charge. We release it after the vehicle is returned,
          in line with our policy. Depending on your bank, the pending authorisation may take a few days to disappear.
        </p>
      </div>
      @endif

      <p class="muted" style="margin-top:16px;font-size:14px">
        If your booking details change, we may issue a new link.
      </p>

      <p style="margin-top:8px">Thanks,<br><strong>{{ $brandName }}</strong></p>
    </div>

    <div class="footer">
      This is an automated message from our payment system. If you weren’t expecting this, please ignore it or contact support.
    </div>
  </div>
</div>
</body>
</html>
