<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <title>Payment receipt</title>
  <style>
    /* Keep CSS simple for email clients */
    body{margin:0;padding:0;background:#f6f7f9;font-family:-apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,Helvetica,Arial,sans-serif;color:#1f2937;}
    .wrap{width:100%;padding:24px 12px;}
    .box{max-width:640px;margin:0 auto;background:#ffffff;border:1px solid #e5e7eb;border-radius:10px;overflow:hidden;}
    .header{padding:20px 24px;border-bottom:1px solid #e5e7eb;background:#fafafa;}
    .brand{font-size:16px;font-weight:600;color:#111827}
    .content{padding:24px;}
    h1{margin:0 0 6px;font-size:22px;line-height:1.3;color:#111827}
    .muted{color:#6b7280;font-size:13px;margin:0}
    .totalCard{margin:18px 0 22px;padding:16px 18px;background:#f9fafb;border:1px solid #e5e7eb;border-radius:8px;display:flex;align-items:center;justify-content:space-between}
    .totalLabel{font-size:13px;color:#6b7280;}
    .totalValue{font-size:24px;font-weight:700;letter-spacing:.2px}
    .grid{display:block;}
    .row{margin:10px 0;font-size:14px}
    .row b{color:#111827}
    code{background:#f3f4f6;border:1px solid #e5e7eb;border-radius:4px;padding:2px 6px;font-family:ui-monospace,SFMono-Regular,Menlo,Monaco,Consolas,monospace;font-size:12px}
    .footer{padding:16px 24px;border-top:1px solid #e5e7eb;background:#fafafa;color:#6b7280;font-size:12px;text-align:center}
    @media (min-width:520px){
      .grid{display:grid;grid-template-columns:1fr 1fr;gap:8px 24px}
    }
  </style>
</head>
<body>
<div class="wrap">
  <div class="box">
    <div class="header">
      <div class="brand">{{ config('app.name', 'Dream Drives') }}</div>
    </div>

    <div class="content">
      <h1>Payment receipt</h1>

      @php
        // ---------- Data hygiene & fallbacks ----------
        // Amount is expected in cents. Prefer the explicit param, then Payment fields.
        $amountCents = (int) (
            ($amount ?? null) !== null ? $amount :
            ($amount_cents ?? null)    ?? 
            ($amountCents ?? null)     ?? 
            ($payment->amount_cents ?? $payment->amount ?? 0)
        );

        // Ensure non-negative
        $amountCents = max(0, (int) $amountCents);

        // Currency code
        $code = strtoupper($currency ?? $payment->currency ?? 'NZD');

        // Simple symbol map
        $symbols = ['NZD'=>'$','USD'=>'$','AUD'=>'$','EUR'=>'€','GBP'=>'£','CAD'=>'$'];
        $sym = $symbols[$code] ?? null;

        // Human display: prefer symbol + code (so it’s unambiguous)
        $amountDisplay = ($sym ? $sym : '') . number_format($amountCents/100, 2) . ' ' . $code;

        // Paid/created date
        try {
            $tz   = config('app.timezone', 'UTC');
            $date = \Illuminate\Support\Carbon::parse($payment->paid_at ?? $payment->created_at ?? now())->timezone($tz)->format('j M Y, g:i a');
        } catch (\Throwable $e) {
            $date = '';
        }
      @endphp

      <p class="muted">
        @if(!empty($job?->id)) Job #{{ $job->id }} &nbsp;•&nbsp; @endif
        @if($date) {{ $date }} @endif
      </p>

      <div class="totalCard">
        <div class="totalLabel">Amount</div>
        <div class="totalValue">{{ $amountDisplay }}</div>
      </div>

      <div class="grid">
        @if(!empty($job?->customer_name))
          <div class="row"><b>Customer</b><br>{{ $job->customer_name }}</div>
        @endif

        @if(!empty($job?->customer_email))
          <div class="row"><b>Email</b><br>{{ $job->customer_email }}</div>
        @endif

        @if(!empty($payment?->reference))
          <div class="row"><b>Reference</b><br><code>{{ $payment->reference }}</code></div>
        @endif

        @php $chargeId = $payment->stripe_charge ?? $payment->stripe_charge_id ?? null; @endphp
        @if($chargeId)
          <div class="row"><b>Stripe charge</b><br><code>{{ $chargeId }}</code></div>
        @endif
      </div>

      <div class="row" style="margin-top:18px;">
        <p class="muted">Thank you for your payment.</p>
      </div>
    </div>

    <div class="footer">
      {{ config('app.name', 'Dream Drives') }} &middot; {{ config('app.url') }}
    </div>
  </div>
</div>
</body>
</html>
