<x-filament::page>
    @php
        // Use NZ time so "today" and the now-indicator are correct for your business
        $nowNz = now('Pacific/Auckland');
    @endphp


    {{-- Legend --}}
    <div class="flex gap-4 text-xs text-gray-400 mb-2">
        <div class="flex items-center gap-1">
            <span class="inline-block w-3 h-3 rounded" style="background:#3b82f6"></span>
            <span>Hire</span>
        </div>
        <div class="flex items-center gap-1">
            <span class="inline-block w-3 h-3 rounded" style="background:#ef4444"></span>
            <span>Maintenance</span>
        </div>
    </div>

    {{-- Calendar container --}}
    <div
        id="fleet-calendar"
        wire:ignore
        style="min-height: 550px; background-color: #0f172a; border-radius: 0.75rem; padding: 0.5rem;"
    ></div>

    {{-- Make the grid feel like day blocks, but keep hour precision under the hood --}}
<style>
    /* Hide all hourly grid lines (both in header and body) */
    .fc .fc-timeline-slots td,
    .fc .fc-timeline-slot-frame,
    .fc .fc-timeline-lanes td,
    .fc .fc-timeline-lane-frame {
        border-left-color: transparent !important;
    }

    /* 78 Add a clear vertical line at each day boundary (every 24 hours) */
    /* Timeline header row */
    .fc .fc-timeline-header-row td:nth-child(24n+1) .fc-timeline-slot-frame {
        border-left: 2px solid rgba(255, 255, 255, 0.18) !important;
    }

    /* Timeline body rows (the event grid) */
    .fc .fc-timeline-lanes td:nth-child(24n+1) .fc-timeline-lane-frame {
        border-left: 2px solid rgba(255, 255, 255, 0.18) !important;
    }

    /* Optional: soften day-end boundaries */
    .fc .fc-timeline-header-row td:last-child .fc-timeline-slot-frame {
        border-right: 2px solid rgba(255, 255, 255, 0.18) !important;
    }

    /* Header row border */
    .fc .fc-timeline-header-row .fc-timeline-slot-frame {
        border-color: rgba(255, 255, 255, 0.15) !important;
    }

    /* Bold red "now" indicator */
    :root {
        --fc-now-indicator-color: #ef4444;
    }
    .fc .fc-now-indicator-line {
        border-color: #ef4444 !important;
        border-width: 2px !important;
    }
    .fc .fc-now-indicator-arrow {
        border-top-color: #ef4444 !important;
    }
</style>








    <script src="https://cdn.jsdelivr.net/npm/fullcalendar-scheduler@6.1.19/index.global.min.js"></script>

<script>
    function initFleetCalendar() {
        const calendarEl = document.getElementById('fleet-calendar');
        if (!calendarEl) {
            console.error('Fleet calendar element not found');
            return;
        }

        const calendar = new FullCalendar.Calendar(calendarEl, {
            schedulerLicenseKey: 'GPL-My-Project-Is-Open-Source',

            timeZone: 'Pacific/Auckland',
            now: '{{ now('Pacific/Auckland')->toIso8601String() }}',

            initialView: 'resourceTimelineWeek',
            height: 550,
           resourceAreaWidth: '220px', 
resourceAreaHeaderContent: 'Vehicles',

            headerToolbar: {
                left: 'prev,next today',
                center: 'title',
                right: 'resourceTimelineDay,resourceTimelineWeek,resourceTimelineMonth'
            },

            /*
             * Timeline axis:
             *  - 1-hour slots under the hood (for accurate times)
             *  - Label once per day
             *  - Tiny slotMinWidth so 7 days fit without horizontal scroll
             */
slotDuration: { hours: 1 },
slotLabelInterval: { hours: 24 },
slotLabelFormat: {
    weekday: 'short',
    day: 'numeric',
},
slotMinWidth: 4,


            nowIndicator: true,
            nowIndicatorSnap: false,
            scrollTime: '{{ now('Pacific/Auckland')->format('H:i:s') }}',
            scrollTimeReset: false,

            resources: '{{ route('fleet-calendar.resources') }}',
            events: '{{ route('fleet-calendar.events') }}',

            eventContent(info) {
                const label = buildEventLabel(info.event, calendar);

                const node = document.createElement('div');
                node.style.whiteSpace = 'nowrap';
                node.style.overflow = 'hidden';
                node.style.textOverflow = 'ellipsis';
                node.style.fontSize = '11px';
                node.textContent = label;

                return { domNodes: [node] };
            },

            eventDidMount(info) {
                const type = info.event.extendedProps.type;

                if (type === 'hire') {
                    info.el.style.backgroundColor = '#3b82f6';
                } else if (type === 'maintenance') {
                    info.el.style.backgroundColor = '#ef4444';
                }

                info.el.style.border = 'none';
                info.el.style.borderRadius = '6px';
                info.el.style.marginTop = '4px';
                info.el.style.marginBottom = '4px';
                info.el.style.height = '20px';

                info.el.title = buildEventLabel(info.event, calendar);
            },

            eventClick(info) {
                const url = info.event.extendedProps.url;
                if (url) {
                    window.open(url, '_blank');
                }
            },

            eventSourceFailure(error) {
                console.error('Event source failed', error);
            },
        });

        calendar.render();
    }

    /**
     * Use FullCalendar's formatter so dates/times respect the calendar timezone.
     */
    function buildEventLabel(event, calendar) {
        const ext  = event.extendedProps || {};
        const type = ext.type || '';

        if (type === 'maintenance') {
            return 'Maintenance';
        }

        const customer = ext.customer || 'Hire';
        const ref      = ext.job_ref || '';

        const start = event.start;
        const end   = event.end;

        let datePart = '';
        let timePart = '';

        if (start && end) {
            const startDateLabel = calendar.formatDate(start, {
                day: '2-digit',
                month: 'short',
            });
            const endDateLabel = calendar.formatDate(end, {
                day: '2-digit',
                month: 'short',
            });

            const startTimeLabel = calendar.formatDate(start, {
                hour: 'numeric',
                minute: '2-digit',
                meridiem: 'short',
            });
            const endTimeLabel = calendar.formatDate(end, {
                hour: 'numeric',
                minute: '2-digit',
                meridiem: 'short',
            });

            datePart = `${startDateLabel}-${endDateLabel}`;
            timePart = `${startTimeLabel} to ${endTimeLabel}`;
        } else if (start) {
            const startDateLabel = calendar.formatDate(start, {
                day: '2-digit',
                month: 'short',
            });
            const startTimeLabel = calendar.formatDate(start, {
                hour: 'numeric',
                minute: '2-digit',
                meridiem: 'short',
            });

            datePart = startDateLabel;
            timePart = startTimeLabel;
        }

        const parts = [];
        if (customer) parts.push(customer);
        if (ref)      parts.push(ref);
        if (datePart) parts.push(datePart);
        if (timePart) parts.push(timePart);

        return parts.join(' - ');
    }

    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', initFleetCalendar);
    } else {
        initFleetCalendar();
    }
</script>


</x-filament::page>
