<x-filament::page>
    {{-- Top: Pickups & Returns --}}
    <div class="grid gap-6 md:grid-cols-2 mb-8">
        {{-- Pickups --}}
        <x-filament::section>
            <x-slot name="heading">Pickups Today</x-slot>

            @forelse ($this->pickupsToday as $job)
                <div class="flex items-center justify-between rounded-lg border border-white/5 bg-gray-900/60 px-4 py-3 mb-2">
                    <div>
                        {{-- main line: pickup time + customer --}}
                        <div class="flex items-center gap-2 text-sm font-medium text-gray-50">
                            <span class="inline-flex h-6 w-6 items-center justify-center rounded-full bg-primary-500/15 text-[11px] font-semibold text-primary-300">
                                {{ optional($job->start_at)->format('H:i') ?? '' }}
                            </span>
                            <span>
                                {{ $job->customer_name ?? 'Unknown customer' }}
                            </span>
                        </div>

                        {{-- second line: vehicle + status --}}
                        <div class="mt-1 text-xs text-gray-400">
                            <span class="font-medium text-gray-300">
                                {{ $job->vehicle_label ?? 'Unassigned' }}
                            </span>

                            @if ($job->start_at)
                                <span class="mx-1 text-gray-500">-</span>
                                Pickup at {{ $job->start_at->format('H:i') }}
                            @endif

                            @if ($this->jobIsOutOnHire($job) && $job->end_at)
                                <span class="ml-2 inline-flex items-center rounded-full bg-amber-500/10 px-2 py-0.5 text-[11px] text-amber-300">
                                    Out until {{ $job->end_at->format('d M H:i') }}
                                </span>
                            @endif
                        </div>
                    </div>

                    <div class="flex items-center gap-2">
                        {{-- DONE CHECKBOX --}}
                        <button
                            wire:click="markPickupDone({{ $job->id }})"
                            class="h-7 w-7 rounded-md border border-gray-500/60 flex items-center justify-center
                                   hover:bg-emerald-500/15 hover:border-emerald-400 transition"
                            title="Mark pickup done"
                        >
                            <x-heroicon-o-check class="h-4 w-4 text-emerald-400"/>
                        </button>

                        {{-- VIEW BUTTON --}}
                        <x-filament::button
                            size="xs"
                            tag="a"
                            href="{{ route('filament.admin.resources.jobs.edit', $job) }}"
                        >
                            View
                        </x-filament::button>
                    </div>
                </div>
            @empty
                <div class="text-sm text-gray-400">No pickups today.</div>
            @endforelse
        </x-filament::section>

        {{-- Returns --}}
        <x-filament::section>
            <x-slot name="heading">Returns Today</x-slot>

            @forelse ($this->returnsToday as $job)
                <div class="flex items-center justify-between rounded-lg border border-white/5 bg-gray-900/60 px-4 py-3 mb-2">
                    <div>
                        <div class="flex items-center gap-2 text-sm font-medium text-gray-50">
                            <span class="inline-flex h-6 w-6 items-center justify-center rounded-full bg-sky-500/15 text-[11px] font-semibold text-sky-300">
                                {{ optional($job->end_at)->format('H:i') ?? '' }}
                            </span>
                            <span>
                                {{ $job->customer_name ?? 'Unknown customer' }}
                            </span>
                        </div>

                        <div class="mt-1 text-xs text-gray-400">
                            <span class="font-medium text-gray-300">
                                {{ $job->vehicle_label ?? 'Unassigned' }}
                            </span>

                            @if ($job->end_at)
                                <span class="mx-1 text-gray-500"></span>
                                Return at {{ $job->end_at->format('H:i') }}
                            @endif

                            @if ($this->jobIsOutOnHire($job) && $job->end_at)
                                <span class="ml-2 inline-flex items-center rounded-full bg-amber-500/10 px-2 py-0.5 text-[11px] text-amber-300">
                                    Out until {{ $job->end_at->format('d M H:i') }}
                                </span>
                            @endif

                            @if ($this->jobBondNotCaptured($job))
                                <span class="ml-2 inline-flex items-center rounded-full bg-rose-500/10 px-2 py-0.5 text-[11px] text-rose-300">
                                    Bond not captured
                                </span>
                            @endif
                        </div>
                    </div>

                    <div class="flex items-center gap-2">
                        {{-- DONE CHECKBOX --}}
                        <button
                            wire:click="markReturnDone({{ $job->id }})"
                            class="h-7 w-7 rounded-md border border-gray-500/60 flex items-center justify-center
                                   hover:bg-emerald-500/15 hover:border-emerald-400 transition"
                            title="Mark return done"
                        >
                            <x-heroicon-o-check class="h-4 w-4 text-emerald-400"/>
                        </button>

                        <x-filament::button
                            size="xs"
                            tag="a"
                            href="{{ route('filament.admin.resources.jobs.edit', $job) }}"
                        >
                            View
                        </x-filament::button>
                    </div>
                </div>
            @empty
                <div class="text-sm text-gray-400">No returns today.</div>
            @endforelse
        </x-filament::section>
    </div>

    {{-- Add Task --}}
    <x-filament::section class="mb-8">
        <x-slot name="heading">Add Task</x-slot>

        <div class="grid gap-4 md:grid-cols-4 items-end">
            <div class="md:col-span-2">
                <label class="block text-sm font-medium text-gray-200 mb-1">
                    Task
                </label>
                <input
                    type="text"
                    wire:model.defer="newTaskTitle"
                    placeholder="e.g. Clean inside of this car"
                    class="block w-full rounded-md border border-gray-700 px-3 py-2 text-sm focus:outline-none focus:ring focus:ring-primary-500/50"
                    style="background-color:#ffffff !important; color:#111827 !important;"
                />
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-200 mb-1">
                    Vehicle
                </label>
                <select
                    wire:model.defer="newTaskVehicleId"
                    class="block w-full rounded-md border border-gray-700 px-3 py-2 text-sm focus:outline-none focus:ring focus:ring-primary-500/50"
                    style="background-color:#ffffff !important; color:#111827 !important;"
                >
                    <option value="">Select vehicle</option>
                    @foreach ($this->vehicles as $vehicle)
                        <option value="{{ $vehicle->id }}">{{ $vehicle->name }}</option>
                    @endforeach
                </select>
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-200 mb-1">
                    For User ID
                </label>
                <input
                    type="number"
                    wire:model.defer="newTaskForUserId"
                    placeholder="optional"
                    class="block w-full rounded-md border border-gray-700 px-3 py-2 text-sm focus:outline-none focus:ring focus:ring-primary-500/50"
                    style="background-color:#ffffff !important; color:#111827 !important;"
                />
            </div>
        </div>

        <div class="mt-4 flex flex-wrap gap-4 items-end">
            <div>
                <label class="block text-sm font-medium text-gray-200 mb-1">
                    Type
                </label>
                <select
                    wire:model.defer="newTaskType"
                    class="block w-full rounded-md border border-gray-700 px-3 py-2 text-sm focus:outline-none focus:ring focus:ring-primary-500/50"
                    style="background-color:#ffffff !important; color:#111827 !important;"
                >
                    <option value="cleaning">Cleaning</option>
                    <option value="mechanical">Mechanical</option>
                    <option value="admin">Admin</option>
                    <option value="booking">Booking</option>
                    <option value="other">Other</option>
                </select>
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-200 mb-1">
                    Priority
                </label>
                <select
                    wire:model.defer="newTaskPriority"
                    class="block w-full rounded-md border border-gray-700 px-3 py-2 text-sm focus:outline-none focus:ring focus:ring-primary-500/50"
                    style="background-color:#ffffff !important; color:#111827 !important;"
                >
                    <option value="1">High</option>
                    <option value="2">Normal</option>
                    <option value="3">Low</option>
                </select>
            </div>

            <div class="mt-2">
                <x-filament::button wire:click="createTask">
                    Add Task
                </x-filament::button>
            </div>
        </div>
    </x-filament::section>

    {{-- Today's Todo List --}}
    <x-filament::section class="mb-8">
        <x-slot name="heading">Today's Todo List</x-slot>

        @forelse ($this->openTasks as $task)
            <div class="flex items-center justify-between rounded-lg border border-white/5 bg-gray-900/60 px-4 py-3 mb-2">
                <div>
                    <div class="flex items-center gap-2">
                        <span class="font-medium text-sm text-gray-50">{{ $task->title }}</span>

                        {{-- Priority badge --}}
                        <span
                            @class([
                                'inline-flex items-center rounded-full px-2 py-0.5 text-[11px]',
                                'bg-rose-500/10 text-rose-300'   => $task->priority === 1,
                                'bg-amber-500/10 text-amber-300' => $task->priority === 2,
                                'bg-gray-500/10 text-gray-300'   => $task->priority === 3,
                            ])
                        >
                            {{ $task->priority_label }}
                        </span>

                        {{-- Type tag --}}
                        <span class="inline-flex items-center rounded-full bg-sky-500/10 px-2 py-0.5 text-sky-300 text-[11px]">
                            {{ $task->type_label }}
                        </span>

                        @if ($task->isOverdue())
                            <span class="inline-flex items-center rounded-full bg-rose-500/10 px-2 py-0.5 text-rose-300 text-[11px]">
                                Overdue
                            </span>
                        @endif
                    </div>

                    <div class="mt-1 text-xs text-gray-400">
                        @if ($task->vehicle)
                            Vehicle: {{ $task->vehicle->name }}
                        @endif

                        @if ($task->forUser)
                            <span class="mx-1 text-gray-500">-</span>
                            For: {{ $task->forUser->name }}
                        @endif

                        <span class="mx-1 text-gray-500">-</span>
                        Created by: {{ $task->creator?->name ?? 'Unknown' }}

                        @if ($task->due_date)
                            <span class="mx-1 text-gray-500">-</span>
                            Due: {{ $task->due_date->format('D d M') }}
                        @endif
                    </div>
                </div>

                <div class="flex items-center gap-2">
                    @if ($task->job)
                        <x-filament::button
                            size="xs"
                            tag="a"
                            href="{{ route('filament.admin.resources.jobs.edit', $task->job) }}"
                        >
                            Job
                        </x-filament::button>
                    @endif

                    @if ($task->vehicle)
                        <x-filament::button
                            size="xs"
                            tag="a"
                            href="{{ route('filament.admin.resources.vehicles.edit', $task->vehicle) }}"
                        >
                            Vehicle
                        </x-filament::button>
                    @endif

                    {{-- Task done tick --}}
                    <button
                        wire:click="markTaskDone({{ $task->id }})"
                        class="h-7 w-7 rounded-md border border-gray-500/60 flex items-center justify-center
                               hover:bg-emerald-500/15 hover:border-emerald-400 transition"
                        title="Mark task done"
                    >
                        <x-heroicon-o-check class="h-4 w-4 text-emerald-400"/>
                    </button>
                </div>
            </div>
        @empty
            <div class="text-sm text-gray-400">No open tasks.</div>
        @endforelse
    </x-filament::section>

    {{-- Overdue Tasks --}}
    <x-filament::section class="mb-8">
        <x-slot name="heading">Overdue Tasks</x-slot>

        @forelse ($this->overdueTasks as $task)
            <div class="flex items-center justify-between py-1 text-sm border-b border-gray-800/40">
                <div>
                    {{ $task->title }}
                    @if ($task->vehicle)
                        <span class="text-gray-500"> - {{ $task->vehicle->name }}</span>
                    @endif
                    <span class="ml-2 text-xs text-rose-400">
                        Due {{ $task->due_date?->format('D d M') }}
                    </span>
                </div>
            </div>
        @empty
            <div class="text-sm text-gray-400">No overdue tasks.</div>
        @endforelse
    </x-filament::section>

    {{-- Completed Today --}}
    <x-filament::section>
        <x-slot name="heading">Completed Today</x-slot>

        @forelse ($this->completedTodayTasks as $task)
            <div class="flex items-center justify-between py-1 text-sm border-b border-gray-800/40">
                <div>
                    {{ $task->title }}
                    @if ($task->vehicle)
                        <span class="text-gray-500"> - {{ $task->vehicle->name }}</span>
                    @endif
                </div>
                <div class="text-xs text-gray-500">
                    {{ $task->completed_at?->format('H:i') }}
                    by {{ $task->completer?->name ?? 'Unknown' }}
                </div>
            </div>
        @empty
            <div class="text-sm text-gray-400">No tasks completed yet.</div>
        @endforelse
    </x-filament::section>
</x-filament::page>
