<x-filament::page class="owner-statement-page">
    <div class="space-y-6 max-w-6xl mx-auto">

        {{-- Owner + date range controls --}}
        <div class="flex flex-wrap items-end gap-4">
            <div>
                <div class="text-sm text-gray-400">Owner</div>
                <div class="text-lg font-semibold text-gray-100">
                    {{ $this->owner->name }}
                </div>
                <div class="text-xs text-gray-500 mt-1">
                    Owner share is set per vehicle (shown in the table below).
                </div>
            </div>

            <div class="ml-auto flex flex-wrap gap-4 items-end">
                <div>
                    <label class="block text-xs font-medium text-gray-400 mb-1">
                        From
                    </label>
                    <input
                        type="date"
                        wire:model.live="startDate"
                        class="fi-input block rounded-lg border border-gray-700 bg-gray-900 text-gray-100 placeholder-gray-400 px-3 py-1.5 text-sm shadow-sm focus:outline-none focus:ring-2 focus:ring-primary-500/70 focus:border-primary-500"
                    />
                </div>

                <div>
                    <label class="block text-xs font-medium text-gray-400 mb-1">
                        To
                    </label>
                    <input
                        type="date"
                        wire:model.live="endDate"
                        class="fi-input block rounded-lg border border-gray-700 bg-gray-900 text-gray-100 placeholder-gray-400 px-3 py-1.5 text-sm shadow-sm focus:outline-none focus:ring-2 focus:ring-primary-500/70 focus:border-primary-500"
                    />
                </div>

                <div class="pt-5">
                    <x-filament::button
                        wire:click="emailStatement"
                        type="button"
                    >
                        Email statement to owner
                    </x-filament::button>
                </div>
            </div>
        </div>

        {{-- Totals --}}
        @php
            $totals = $this->getTotals();
            $fmt = fn (int $cents) => '$' . number_format($cents / 100, 2);
        @endphp

        <div class="grid gap-4 sm:grid-cols-2 lg:grid-cols-4">
            <div class="rounded-xl border border-gray-700 bg-gray-900/50 p-4">
                <div class="text-xs text-gray-400">Earnings</div>
                <div class="mt-1 text-xl font-semibold text-gray-50">
                    {{ $fmt($totals['earnings_cents']) }}
                </div>
            </div>

            <div class="rounded-xl border border-gray-700 bg-gray-900/50 p-4">
                <div class="text-xs text-gray-400">Costs</div>
                <div class="mt-1 text-xl font-semibold text-gray-50">
                    {{ $fmt($totals['costs_cents']) }}
                </div>
            </div>

            <div class="rounded-xl border border-gray-700 bg-gray-900/50 p-4">
                <div class="text-xs text-gray-400">Payouts</div>
                <div class="mt-1 text-xl font-semibold text-gray-50">
                    {{ $fmt($totals['payouts_cents']) }}
                </div>
            </div>

            <div class="rounded-xl border border-gray-700 bg-gray-900/50 p-4">
                <div class="text-xs text-gray-400">Balance (for range)</div>
                <div class="mt-1 text-xl font-semibold text-gray-50">
                    {{ $fmt($totals['balance_cents']) }}
                </div>
            </div>
        </div>

        {{-- Ledger table for the range --}}
        @php $entries = $this->getEntries(); @endphp

        <div class="rounded-xl border border-gray-700 bg-gray-900/50 overflow-hidden">
            <div class="border-b border-gray-700 px-4 py-3 text-sm font-semibold text-gray-100 flex items-center justify-between">
                <span>Ledger entries ({{ $entries->count() }})</span>
            </div>

            <div class="overflow-x-auto">
                <table class="min-w-full text-sm">
                    <thead class="bg-gray-900/80">
                        <tr class="text-left text-xs uppercase tracking-wide text-gray-400">
                            <th class="px-4 py-2 font-medium">Date</th>
                            <th class="px-4 py-2 font-medium">Type</th>
                            <th class="px-4 py-2 text-right font-medium">Raw amount</th>
                            <th class="px-4 py-2 text-right font-medium">Owner&nbsp;%</th>
                            <th class="px-4 py-2 text-right font-medium">Owner amount</th>
                            <th class="px-4 py-2 font-medium">Vehicle</th>
                            <th class="px-4 py-2 font-medium">Booking</th>
                            <th class="px-4 py-2 font-medium">Description</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-800">
                        @forelse ($entries as $entry)
                            @php
                                $typeEnum = $entry->type;
                                $type = $typeEnum instanceof \BackedEnum ? $typeEnum->value : $typeEnum;

                                $rawCents      = (int) $entry->amount_cents;
                                $rawAmount     = $fmt($rawCents);
                                $ownerPercent  = $entry->vehicle?->owner_share_percent;
                                $ownerCents    = $rawCents;

                                if ($type === 'earning' && $ownerPercent !== null) {
                                    $ownerCents = (int) round($rawCents * ($ownerPercent / 100));
                                }

                                $ownerAmount = $fmt($ownerCents);
                            @endphp

                            <tr class="hover:bg-gray-900/60 transition-colors">
                                <td class="px-4 py-2 text-gray-200 whitespace-nowrap align-top">
                                    {{ optional($entry->occurred_at)->format('Y-m-d H:i') }}
                                </td>

                                <td class="px-4 py-2 align-top">
                                    <span class="inline-flex items-center rounded-full px-2 py-0.5 text-xs border
                                        @if ($type === 'earning') bg-emerald-500/10 text-emerald-300 border-emerald-500/40
                                        @elseif ($type === 'cost') bg-red-500/10 text-red-300 border-red-500/40
                                        @elseif ($type === 'payout') bg-amber-500/10 text-amber-300 border-amber-500/40
                                        @else bg-sky-500/10 text-sky-300 border-sky-500/40 @endif">
                                        {{ ucfirst($type) }}
                                    </span>
                                </td>

                                <td class="px-4 py-2 text-right text-gray-100 whitespace-nowrap align-top">
                                    {{ $rawAmount }}
                                </td>

                                <td class="px-4 py-2 text-right text-gray-200 whitespace-nowrap align-top">
                                    @if ($type === 'earning' && $ownerPercent !== null)
                                        {{ $ownerPercent }}%
                                    @elseif (in_array($type, ['cost', 'payout']))
                                        100%
                                    @else
                                        —
                                    @endif
                                </td>

                                <td class="px-4 py-2 text-right text-gray-100 whitespace-nowrap align-top">
                                    {{ $ownerAmount }}
                                </td>

                                <td class="px-4 py-2 text-gray-300 whitespace-nowrap align-top">
                                    {{ $entry->vehicle?->name }}
                                </td>

                                <td class="px-4 py-2 text-gray-300 whitespace-nowrap align-top">
                                    {{ $entry->job?->booking_reference }}
                                </td>

                                <td class="px-4 py-2 text-gray-300 align-top">
                                    {{ $entry->description }}
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="8" class="px-4 py-4 text-center text-gray-400">
                                    No ledger entries in this date range.
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>

    </div>

    <style>
        /* Scope tweaks just to this page */

        .owner-statement-page .fi-input {
            border-color: #4b5563; /* gray-600 */
        }

        .owner-statement-page .border-gray-800 {
            border-color: #4b5563; /* gray-600 */
        }

        .owner-statement-page .divide-gray-800 > :not([hidden]) ~ :not([hidden]) {
            border-color: #4b5563;
        }

        /* FORCE dark-mode styling for native date inputs */
        .owner-statement-page input[type="date"] {
            background-color: #111827 !important; /* gray-900 */
            color: #f9fafb !important;            /* gray-50 */
            border-color: #4b5563 !important;     /* gray-600 */
        }

        .owner-statement-page input[type="date"]::placeholder {
            color: #9ca3af !important;            /* gray-400 */
        }

        /* WebKit-specific inner text for date inputs */
        .owner-statement-page input[type="date"]::-webkit-datetime-edit,
        .owner-statement-page input[type="date"]::-webkit-datetime-edit-fields-wrapper,
        .owner-statement-page input[type="date"]::-webkit-datetime-edit-text,
        .owner-statement-page input[type="date"]::-webkit-datetime-edit-month-field,
        .owner-statement-page input[type="date"]::-webkit-datetime-edit-day-field,
        .owner-statement-page input[type="date"]::-webkit-datetime-edit-year-field {
            color: #f9fafb !important;
        }

        .owner-statement-page input[type="date"]::-webkit-calendar-picker-indicator {
            filter: invert(1); /* make the calendar icon visible on dark background */
        }
    </style>
</x-filament::page>
