<x-filament::widget>
    <x-filament::card class="bg-gray-900 border-gray-800">

        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">

            {{-- ===================== COLUMN 1 — PICKUPS ===================== --}}
            <div>
                <h3 class="text-sm font-semibold text-gray-300 mb-2">Pickups Today</h3>

                @if ($pickupsCount === 0)
                    <p class="text-xs text-gray-500">No pickups today.</p>
                @else
                    <div class="space-y-2">
                        @foreach ($pickups as $job)
                            @php
                                $vehicleModel = $job->vehicle;

                                // Build a nice vehicle label: REGO – Name
                                if ($vehicleModel) {
                                    $vehicleLabel = trim(
                                        ($vehicleModel->registration ? $vehicleModel->registration . ' – ' : '') .
                                        ($vehicleModel->display_name ?? $vehicleModel->name ?? '')
                                    );
                                } else {
                                    $vehicleLabel = '';
                                }

                                if ($vehicleLabel === '') {
                                    $vehicleLabel = 'Vehicle not assigned';
                                }

                                $ref = $job->booking_reference
                                    ?? $job->job_reference
                                    ?? $job->reference
                                    ?? 'No ref';
                            @endphp

                            <a href="{{ route('filament.admin.resources.jobs.view', $job) }}"
                               class="block rounded-lg border border-gray-700 px-3 py-2 bg-gray-800 hover:bg-gray-750 transition">
                                <div class="flex justify-between">
                                    <div class="text-sm font-medium text-gray-100 truncate">
                                        {{ $vehicleLabel }}
                                    </div>
                                    <div class="text-xs text-gray-400">
                                        {{ optional($job->start_at)->format('H:i') }}
                                    </div>
                                </div>

                                <div class="text-xs text-gray-400 truncate">
                                    {{ $ref }}
                                </div>

                                <div class="text-xs text-gray-500 truncate">
                                    {{ $job->customer_name }}
                                </div>
                            </a>
                        @endforeach
                    </div>
                @endif
            </div>

            {{-- ===================== COLUMN 2 — RETURNS ===================== --}}
            <div>
                <h3 class="text-sm font-semibold text-gray-300 mb-2">Returns Today</h3>

                @if ($returnsCount === 0)
                    <p class="text-xs text-gray-500">No returns today.</p>
                @else
                    <div class="space-y-2">
                        @foreach ($returns as $job)
                            @php
                                $vehicleModel = $job->vehicle;

                                // Same vehicle label logic as pickups
                                if ($vehicleModel) {
                                    $vehicleLabel = trim(
                                        ($vehicleModel->registration ? $vehicleModel->registration . ' – ' : '') .
                                        ($vehicleModel->display_name ?? $vehicleModel->name ?? '')
                                    );
                                } else {
                                    $vehicleLabel = '';
                                }

                                if ($vehicleLabel === '') {
                                    $vehicleLabel = 'Vehicle not assigned';
                                }

                                $ref = $job->booking_reference
                                    ?? $job->job_reference
                                    ?? $job->reference
                                    ?? 'No ref';
                            @endphp

                            <a href="{{ route('filament.admin.resources.jobs.view', $job) }}"
                               class="block rounded-lg border border-gray-700 px-3 py-2 bg-gray-800 hover:bg-gray-750 transition">
                                <div class="flex justify-between">
                                    <div class="text-sm font-medium text-gray-100 truncate">
                                        {{ $vehicleLabel }}
                                    </div>
                                    <div class="text-xs text-gray-400">
                                        {{ optional($job->end_at)->format('H:i') }}
                                    </div>
                                </div>

                                <div class="text-xs text-gray-400 truncate">
                                    {{ $ref }}
                                </div>

                                <div class="text-xs text-gray-500 truncate">
                                    {{ $job->customer_name }}
                                </div>
                            </a>
                        @endforeach
                    </div>
                @endif
            </div>

            {{-- ===================== COLUMN 3 — TASKS ===================== --}}
            <div>
                <div class="flex items-center justify-between mb-2">
                    <h3 class="text-sm font-semibold text-gray-300">
                        Tasks (due / overdue)
                    </h3>

                    {{-- Vehicle maintenance button --}}
                    <x-filament::button
                        tag="a"
                        size="xs"
                        color="gray"
                        href="{{ \App\Filament\Resources\VehicleMaintenanceLogResource::getUrl('index') }}"
                    >
                        Vehicle maintenance
                    </x-filament::button>
                </div>

                @if ($tasksCount === 0)
                    <p class="text-xs text-gray-500">No tasks due.</p>
                @else
                    <div class="space-y-2">
                        @foreach ($tasks as $task)
                            @php
                                $vehicleModel = $task->vehicle;

                                $taskVehicle = $vehicleModel
                                    ? trim(
                                        ($vehicleModel->registration ? $vehicleModel->registration . ' – ' : '') .
                                        ($vehicleModel->display_name ?? $vehicleModel->name ?? '')
                                    )
                                    : null;
                            @endphp

                            <a href="{{ $task->job_id ? route('filament.admin.resources.jobs.view', $task->job_id) : '#' }}"
                               class="block rounded-lg border border-gray-700 px-3 py-2 bg-gray-800 hover:bg-gray-750 transition">
                                <div class="flex justify-between">
                                    <div class="text-sm font-medium text-gray-100 truncate">
                                        {{ $task->title }}
                                    </div>
                                    <div class="text-xs text-gray-400">
                                        {{ optional($task->due_date)->format('d M') }}
                                    </div>
                                </div>

                                @if ($taskVehicle)
                                    <div class="text-xs text-gray-400 truncate">
                                        {{ $taskVehicle }}
                                    </div>
                                @endif
                            </a>
                        @endforeach
                    </div>
                @endif
            </div>

        </div>
    </x-filament::card>
</x-filament::widget>
