@php
$cur = strtoupper($deposit->currency ?? 'NZD');
$symbol = match ($cur) { 'NZD'=>'NZ$', 'AUD'=>'A$', 'USD'=>'$', 'GBP'=>'£', 'EUR'=>'€', default=>$cur.' ' };
$amount = number_format((int)($deposit->authorized_cents ?? $deposit->authorised_cents ?? $deposit->amount_cents ?? 0)/100, 2);
@endphp

@component('mail::message')
# Hold released

Hi,

The refundable security hold for your booking **#{{ $job->reference ?? $job->id }}** has been **released**.

- **Amount:** {{ $symbol }}{{ $amount }}  
- **Status:** released  
- **Booking end:** {{ \Illuminate\Support\Carbon::parse($job->end_at ?? now())->timezone(config('app.timezone','UTC'))->toDayDateTimeString() }}

If you have any questions, just reply to this email.

Thanks,  
{{ config('app.name') }}
@endcomponent
