@php
    /** @var \App\Models\Owner $owner */
    /** @var \Illuminate\Support\Carbon $fromDate */
    /** @var \Illuminate\Support\Carbon $toDate */
    /** @var array $totals */
    /** @var int $payoutAmountCents */
    /** @var array|null $previewTotals */
    /** @var \Illuminate\Support\Carbon|null $previewPayoutDate */
    /** @var \Illuminate\Support\Collection|null $previewJobs */
    /** @var \Illuminate\Support\Collection|null $vehicles */
    /** @var string $statementId */

    $earnings    = $totals['earnings_cents']    ?? 0;
    $costs       = $totals['costs_cents']       ?? 0;
    $payouts     = $totals['payouts_cents']     ?? 0;
    $adjustments = $totals['adjustments_cents'] ?? 0;
    $balance     = $totals['balance_cents']     ?? 0;

    $fmt = fn (int $cents) => '$' . number_format($cents / 100, 2);

    // Normalise preview data so this view never explodes
    $previewTotals     = $previewTotals     ?? ['owner_total_cents' => 0, 'month_label' => null, 'per_vehicle_cents' => []];
    $previewPayoutDate = $previewPayoutDate ?? now()->copy()->day(10);
    $previewJobs       = isset($previewJobs) ? $previewJobs : collect();

    $previewOwnerTotal = $previewTotals['owner_total_cents'] ?? 0;
    $previewMonthLabel = $previewTotals['month_label'] ?? $previewPayoutDate->format('F Y');
    $previewPerVehicle = $previewTotals['per_vehicle_cents'] ?? [];
@endphp

<p>Hi {{ $owner->legal_name ?? $owner->name }},</p>

<p>
    Please find attached your owner statement for
    <strong>{{ $fromDate->toFormattedDateString() }}</strong>
    to
    <strong>{{ $toDate->toFormattedDateString() }}</strong>.
</p>

<p>
    <strong>Earnings (your share)</strong> {{ $fmt($earnings) }}<br>
    <strong>Adjustments</strong> {{ $fmt($adjustments) }}<br>
    <strong>Costs</strong> {{ $fmt($costs) }}<br>
    <strong>Payouts</strong> {{ $fmt($payouts) }}<br>
    <strong>Balance</strong> {{ $fmt($balance) }}
</p>

@if ($payoutAmountCents !== 0)
    <p>
        We’ve paid
        <strong>{{ $fmt($payoutAmountCents) }}</strong>
        to your nominated bank account today.
    </p>
@endif

@if ($previewOwnerTotal > 0)
    <hr>
    <p>
        <strong>Looking ahead – next payout</strong><br>
        Estimated owner share for bookings ending in
        <strong>{{ $previewMonthLabel }}</strong> is
        <strong>{{ $fmt($previewOwnerTotal) }}</strong>.
        These are expected to be paid on
        <strong>{{ $previewPayoutDate->toFormattedDateString() }}</strong>,
        according to our payout schedule (10th of each month for the previous month’s completed bookings).
    </p>

    @if (!empty($previewPerVehicle))
        <p>
            <strong>By vehicle:</strong><br>
            @foreach ($previewPerVehicle as $vehicleName => $ownerCents)
                • {{ $vehicleName }} – {{ $fmt($ownerCents) }}<br>
            @endforeach
        </p>
    @endif
@endif

@if ($previewJobs->isNotEmpty())
    <hr>
    <p>
        <strong>Your vehicle is booked on:</strong><br>
        @foreach ($previewJobs as $job)
            @php
                $start = \Carbon\Carbon::parse($job->start_at)->toFormattedDateString();
                $end   = \Carbon\Carbon::parse($job->end_at)->toFormattedDateString();
            @endphp
            • {{ $job->vehicle?->name }}:
              {{ $start }} – {{ $end }}<br>
        @endforeach
    </p>
@endif

<p>
    If you have any questions about this statement, just reply to this email and we’ll be happy to help.
</p>

<p>
    Thanks,<br>
    Dream Drives
</p>
