@php
    /** Expected: $job, $payment. Optional: $brand, $amountCents, $currency, $bookingRef, $startAt, $endAt, $viewUrl */

    // Brand / logo (keeps parity with the request template)
    $brandName = $brand->short_name ?? 'Dream Drives';
    $logo      = $brand->email_logo_url ?? null;

    // Currency + formatter
    $ccy = strtoupper($currency ?? $payment->currency ?? $job->currency ?? 'NZD');
    $sym = [
        'NZD' => 'NZ$', 'AUD' => 'A$', 'USD' => '$', 'GBP' => '£', 'EUR' => '€', 'CAD' => 'C$',
    ][$ccy] ?? $ccy;

    $fmt = fn ($c) => $sym . number_format(((int) $c) / 100, 2);

    // Amount (prefer explicit amountCents if passed)
    $amount = isset($amountCents)
        ? (int) $amountCents
        : (int) ($payment->amount_cents ?? $payment->amount ?? 0);

    // Person/name
    $firstName = trim(explode(' ', $job->customer_name ?? 'there')[0] ?? 'there');

    // Times / dates
    $formatDt = function ($v, $fmt = 'D d M Y, h:ia') {
        try {
            if ($v instanceof \Illuminate\Support\Carbon || $v instanceof \Carbon\Carbon) return $v->format($fmt);
            return \Carbon\Carbon::parse($v)->format($fmt);
        } catch (\Throwable $e) { return null; }
    };

    $paidAt   = $formatDt($payment->created_at ?? now());
    $startTxt = isset($startAt) ? $formatDt($startAt, 'D d M Y, H:i') : ($job->start_at ? $formatDt($job->start_at, 'D d M Y, H:i') : null);
    $endTxt   = isset($endAt)   ? $formatDt($endAt,   'D d M Y, H:i') : ($job->end_at   ? $formatDt($job->end_at,   'D d M Y, H:i') : null);

    // References
    $ref      = $bookingRef ?? $job->external_reference ?? null;
    $charge   = $payment->stripe_charge ?? $payment->stripe_charge_id ?? null;
    $pi       = $payment->stripe_payment_intent ?? $payment->stripe_payment_intent_id ?? null;
@endphp

@component('mail::message')
@if($logo)
<p style="text-align:center;margin:0 0 12px">
  <img src="{{ $logo }}" alt="{{ $brandName }}" style="max-height:42px">
</p>
@endif

# Payment receipt

Hi {{ $firstName }},

We’ve received your payment for **Job #{{ $job->id }}** ({{ $brandName }}).

**Amount paid:** {{ $fmt($amount) }} <span style="color:#6b7280">({{ $ccy }})</span>  
**Paid at:** {{ $paidAt }}

---

**Receipt summary**
- Job: **#{{ $job->id }}**
@isset($ref)
- Reservation reference: **{{ $ref }}**
@endisset
@if($startTxt || $endTxt)
- Dates: {{ $startTxt }} → {{ $endTxt }}
@endif
@if(!empty($job->customer_name))
- Customer: {{ $job->customer_name }}
@endif
@if(!empty($job->customer_email))
- Email: <a href="mailto:{{ $job->customer_email }}">{{ $job->customer_email }}</a>
@endif
@if(!empty($job->customer_phone))
- Phone: {{ $job->customer_phone }}
@endif
@isset($charge)
- Stripe charge: `{{ $charge }}`
@endisset
@isset($pi)
- Payment intent: `{{ $pi }}`
@endisset

@isset($viewUrl)
@component('mail::button', ['url' => $viewUrl])
View booking
@endcomponent
@endisset

Thanks,  
**{{ $brandName }}**

<small>This is an automated receipt. If you have questions, just reply to this email.  
If your booking includes a refundable security hold, it may show as “pending” and will be released per our policy.</small>
@endcomponent
