@php
    /** Expects: $job, $payUrl. Optional: $brand, $purpose, $amountCents, $holdCents, $invoiceNumber, $invoiceUrl */

    // Brand / logo
    $brandName = $brand->short_name ?? 'Dream Drives';
    $logo      = $brand->email_logo_url ?? null;

    // Currency + formatter
    $ccy = strtoupper($job->currency ?? 'NZD');
    $sym = ['NZD'=>'NZ$','AUD'=>'A$','USD'=>'$','GBP'=>'£','EUR'=>'€','CAD'=>'C$'][$ccy] ?? $ccy;
    $fmt = fn ($c) => $sym . number_format(((int) $c) / 100, 2);

    // Label (e.g. “Payment”, “Deposit”, etc.)
    $label = $purpose ? ucfirst($purpose) : 'Payment';

    // Booking reference / customer
    $ref   = $job->external_reference ?? null;
    $name  = $job->customer_name ?? 'there';

    // Dates (nicely formatted; safe if missing)
    $fdt = function ($v, $format = 'D d M Y, H:i') {
        try {
            if ($v instanceof \Illuminate\Support\Carbon || $v instanceof \Carbon\Carbon) return $v->format($format);
            return \Carbon\Carbon::parse($v)->format($format);
        } catch (\Throwable $e) {
            return null;
        }
    };
    $startTxt = $fdt($job->start_at);
    $endTxt   = $fdt($job->end_at);

    // Amount due (if provided by caller)
    $amountTxt = isset($amountCents) ? $fmt($amountCents) : null;

    // Hold amount (prefer explicit; else from deposit/flow), only show if > 0
    $holdCents = isset($holdCents)
        ? (int) $holdCents
        : (int) (
            optional($job->deposit)->authorized_cents
            ?? ($job->hold_amount_cents_from_flow ?? optional($job->flow)->hold_amount_cents ?? 0)
        );
@endphp

@component('mail::message')
@if($logo)
<p style="text-align:center;margin:0 0 12px">
  <img src="{{ $logo }}" alt="{{ $brandName }}" style="max-height:42px">
</p>
@endif

# Secure {{ strtolower($label) }}

Hi {{ $name }},

We’ve set up a secure payment link for your booking
@if($ref)
**{{ $ref }}**
@else
**#{{ $job->id }}**
@endif
with **{{ $brandName }}**.

@isset($amountTxt)
Please pay **{{ $amountTxt }}** to confirm your reservation.
@else
Please follow the link below to complete payment.
@endisset

@component('mail::button', ['url' => $payUrl])
Pay now
@endcomponent

If the button doesn’t work, copy and paste this link:<br>
<span style="word-break:break-all">{{ $payUrl }}</span>

---

### Reservation Summary
- **Reservation reference:** {{ $ref ?? ('#'.$job->id) }}
- **Name:** {{ $job->customer_name ?? '—' }}
- **Email:** @if(!empty($job->customer_email))<a href="mailto:{{ $job->customer_email }}">{{ $job->customer_email }}</a>@else — @endif
- **Phone:** {{ $job->customer_phone ?? '—' }}
@if($startTxt || $endTxt)
- **Start:** {{ $startTxt ?? '—' }}
- **End:** {{ $endTxt ?? '—' }}
@endif
@isset($amountTxt)
- **Amount due:** {{ $amountTxt }} ({{ $ccy }})
@endisset

@isset($invoiceNumber)
> **Invoice:** {{ $invoiceNumber }} @if(!empty($invoiceUrl)) — <a href="{{ $invoiceUrl }}">View online</a>@endif  
@endif
@empty($invoiceNumber)
    @isset($invoiceUrl)
> **Invoice:** <a href="{{ $invoiceUrl }}">View online</a>
    @endisset
@endempty

@php $showHold = $holdCents > 0; @endphp
@if($showHold)
---
**About the refundable security hold**

- A refundable security hold of **{{ $fmt($holdCents) }}** may appear as *“pending”* on your card.  
- It isn’t a charge. We **release it after the vehicle is returned** in accordance with our policy.  
- Depending on your bank, the “pending” authorisation may take a few days to disappear.
@endif

---

If your booking details change, we may issue a new link.

Thanks,  
**{{ $brandName }}**

<small>This is an automated message from our payment system. If you weren’t expecting this, please ignore this email or contact support.</small>
@endcomponent
