@component('mail::message')
# Payment Request

**Amount:** {{ money_format_nzd($payment->amount_cents) }}  
**Reason:** {{ $payment->reason ?? 'One-off charge' }}

@if($note)
> {{ $note }}
@endif

@component('mail::button', ['url' => $checkoutUrl])
Pay Securely
@endcomponent

@if(!empty($attachments))
### Supporting evidence
@foreach($attachments as $file)
- <a href="{{ $file['url'] }}" target="_blank" rel="noopener">
    {{ $file['name'] }}
  </a>
  <small>({{ $file['mime'] ?? 'file' }}, {{ format_bytes($file['size'] ?? 0) }})</small>
@endforeach
@endif

Thanks,  
{{ config('app.name') }}
@endcomponent
