<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Payment Cancelled</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <style>
    body { font-family: ui-sans-serif, system-ui, -apple-system, Segoe UI, Roboto, Helvetica, Arial, "Apple Color Emoji","Segoe UI Emoji"; margin:0; background:#1a1414; color:#f5ecec; }
    .wrap { max-width: 720px; margin: 6rem auto; padding: 2rem; }
    .card { background:#221b1b; border:1px solid #3a2e2e; border-radius:16px; padding:2rem; }
    h1 { margin:0 0 0.75rem; font-size:1.75rem; }
    p { margin:0.5rem 0; line-height:1.6; color:#eadcdc; }
    code { background:#2a2121; padding:0.15rem 0.35rem; border-radius:6px; font-size:0.95em; }
    .row { margin-top:1.25rem; display:flex; gap:.75rem; flex-wrap:wrap; }
    .btn { display:inline-block; padding:0.7rem 1rem; border-radius:10px; text-decoration:none; }
    .btn-primary { background:#9333ea; color:#fff; }
    .btn-ghost { background:transparent; color:#eadcdc; border:1px solid #3a2e2e; }
    .meta { margin-top:1rem; font-size:0.95rem; color:#d5c6c6; }
  </style>
</head>
<body>
  <div class="wrap">
    <div class="card">
      <h1>Payment cancelled</h1>
      <p>No problem — nothing was charged.</p>

      @if(!empty($token))
        <p class="meta">Token: <code>{{ $token }}</code></p>
      @endif

      <div class="row">
        @isset($resumeUrl)
          <a href="{{ $resumeUrl }}" class="btn btn-primary">Return to payment</a>
        @endisset
        @isset($supportUrl)
          <a href="{{ $supportUrl }}" class="btn btn-ghost" target="_blank" rel="noopener">Contact support</a>
        @endisset
        <a href="/" class="btn btn-ghost">Back to home</a>
      </div>
    </div>
  </div>
</body>
</html>
