<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Link Not Found</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <style>
    body { font-family: ui-sans-serif, system-ui, -apple-system, Segoe UI, Roboto, Helvetica, Arial, "Apple Color Emoji","Segoe UI Emoji"; margin:0; background:#0f1220; color:#e6e8f2; }
    .wrap { max-width: 720px; margin: 6rem auto; padding: 2rem; }
    .card { background:#141830; border:1px solid #20264b; border-radius:16px; padding:2rem; }
    h1 { margin:0 0 0.75rem; font-size:1.75rem; }
    p { margin:0.5rem 0; line-height:1.6; color:#cbd3ee; }
    code { background:#0c0f1d; padding:0.15rem 0.35rem; border-radius:6px; font-size:0.95em; }
    .hint { margin-top:1rem; font-size:0.95rem; color:#aab4de; }
    .btn { display:inline-block; margin-top:1.25rem; padding:0.7rem 1rem; border-radius:10px; text-decoration:none; background:#2563eb; color:#fff; }
  </style>
</head>
<body>
  <div class="wrap">
    <div class="card">
      <h1>We couldn’t find that payment link</h1>
      @if(!empty($token))
        <p class="hint">Token: <code>{{ $token }}</code></p>
      @endif
      <p class="hint">The link may be expired or already used. If you believe this is an error, please contact support.</p>
      @isset($supportUrl)
        <a href="{{ $supportUrl }}" class="btn" target="_blank" rel="noopener">Contact support</a>
      @endisset
      <a href="/" class="btn" style="background:#374151; margin-left:.5rem;">Back to home</a>
    </div>
  </div>
</body>
</html>
