<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Payment Successful</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <style>
    body { font-family: ui-sans-serif, system-ui, -apple-system, Segoe UI, Roboto, Helvetica, Arial, "Apple Color Emoji","Segoe UI Emoji"; margin:0; background:#0b1727; color:#e9eef5; }
    .wrap { max-width: 720px; margin: 6rem auto; padding: 2rem; }
    .card { background:#111a2b; border:1px solid #1b2a44; border-radius:16px; padding:2rem; }
    h1 { margin:0 0 0.75rem; font-size:1.75rem; }
    p { margin:0.5rem 0; line-height:1.6; color:#cfd7e6; }
    .row { display:flex; justify-content:space-between; align-items:center; gap:1rem; padding:0.5rem 0; border-top:1px solid #1b2a44; }
    .row:first-of-type { border-top:0; }
    .row span { color:#cfd7e6; }
    .row strong { background:#0a1322; color:#e9eef5; padding:0.15rem 0.5rem; border-radius:6px; font-weight:600; letter-spacing:0.02em; }
    .meta { margin-top:1rem; font-size:0.95rem; color:#9fb1d1; }
  </style>
</head>
<body>
  <div class="wrap">
    <div class="card">
      <h1>Thanks — payment received ✅</h1>

      <p>Your payment was successful and your booking is now confirmed.</p>
      <p>We’re genuinely grateful you’ve chosen to hire a car with us — we look forward to meeting you soon.</p>

      @php
        // 1) Prefer the exact Booking Reference passed from the pay page (?ref=...)
        $refFromQuery = request('ref');

        // 2) Fallbacks if the query param isn't present
        $candidates = [
          'job.ref',
          'job.reference',
          'job.booking_reference',
          'job.reservation_number',
          'booking_reference',
          'reservation_number',
          'metadata.job_ref',
          'metadata.job_reference',
          'meta.job_ref',
          'meta.job_reference',
        ];

        $fallbackRef = null;
        foreach ($candidates as $key) {
          $val = data_get($payment ?? [], $key);
          if (is_string($val) && trim($val) !== '') { $fallbackRef = trim($val); break; }
        }
        if (! $fallbackRef) {
          $fallbackRef = $payment->reference ?? $payment->id ?? null; // absolute last resort
        }

        $referenceToShow = $refFromQuery ?: $fallbackRef;

        // Booking dates (payment -> job -> booking)
        $startDate = data_get($payment, 'start_date') ?? data_get($payment, 'job.start_date') ?? data_get($payment, 'booking.start_date');
        $endDate   = data_get($payment, 'end_date')   ?? data_get($payment, 'job.end_date')   ?? data_get($payment, 'booking.end_date');
        $start = $startDate ? \Carbon\Carbon::parse($startDate)->timezone('Pacific/Auckland')->format('j M Y, g:i A T') : null;
        $end   = $endDate   ? \Carbon\Carbon::parse($endDate)->timezone('Pacific/Auckland')->format('j M Y, g:i A T')   : null;

        // Amount + currency symbol
        $amount   = isset($payment->amount_cents) ? number_format($payment->amount_cents/100, 2) : null;
        $currency = $payment->currency ?? 'NZD';
        $symbols  = ['NZD'=>'$','AUD'=>'$','USD'=>'$','EUR'=>'€','GBP'=>'£','JPY'=>'¥'];
        $symbol   = $symbols[$currency] ?? '';
      @endphp

      <!-- Booking Reference (from ?ref=... first, then fallbacks) -->
      <div class="row"><span>Booking Reference</span><strong>{{ $referenceToShow ?? '—' }}</strong></div>

      @if($amount)
        <div class="row"><span>Amount</span><strong>{{ $symbol }}{{ $amount }} {{ $currency }}</strong></div>
      @endif

      @if($start || $end)
        <div class="row">
          <span>Booking dates</span>
          <strong>
            @if($start) {{ $start }} @endif
            @if($start && $end) &nbsp;→&nbsp; @endif
            @if($end) {{ $end }} @endif
          </strong>
        </div>
      @endif

      <p class="meta">A receipt has been emailed to you (if applicable).</p>

      <!-- debug (optional): remove after confirming -->
      <!-- source: {{ $refFromQuery ? 'query.ref' : 'fallback' }} -->
    </div>
  </div>
</body>
</html>
