{{-- resources/views/payments/hold.blade.php --}}
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Authorise Security Hold</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <script src="https://js.stripe.com/v3/"></script>
    <style>
        body {
            font-family: system-ui, sans-serif;
            background: #f9fafb;
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 480px;
            margin: 60px auto;
            background: #fff;
            border-radius: 12px;
            box-shadow: 0 4px 12px rgba(0,0,0,.08);
            padding: 32px;
        }
        h1 {
            font-size: 1.4rem;
            margin-bottom: 12px;
        }
        .summary {
            font-size: .95rem;
            margin-bottom: 20px;
            color: #444;
        }
        #payment-element {
            margin-bottom: 20px;
        }
        button {
            width: 100%;
            background: #4f46e5;
            color: #fff;
            font-size: 1rem;
            padding: 12px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
        }
        button:disabled {
            opacity: .5;
            cursor: not-allowed;
        }
        .error {
            color: #dc2626;
            margin-top: 10px;
            font-size: .9rem;
        }
        .success {
            color: #16a34a;
            margin-top: 10px;
            font-size: .9rem;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Security Hold Authorisation</h1>
        <p class="summary">
            A refundable hold of <strong>NZ$200.00</strong> will be placed on your card.  
            This is not a charge — it will be released after your booking unless required.
        </p>

        <div id="payment-element"></div>
        <button id="submit-btn">Authorise Hold</button>

        <div id="message"></div>
    </div>

    <script>
        const stripe = Stripe("{{ config('services.stripe.key') }}");

        let elements;
        let clientSecret;

        async function init() {
            // Call backend to create PaymentIntent for NZ$200 manual capture
            const res = await fetch("{{ route('payments.createHold') }}", {
                method: "POST",
                headers: {
                    "Content-Type": "application/json",
                    "X-CSRF-TOKEN": "{{ csrf_token() }}"
                },
                body: JSON.stringify({
                    job_id: {{ $job->id }},
                    deposit_id: {{ $deposit->id }}
                })
            });
            const data = await res.json();
            clientSecret = data.client_secret;

            elements = stripe.elements({ clientSecret });
            const paymentElement = elements.create("payment");
            paymentElement.mount("#payment-element");
        }

        document.getElementById("submit-btn").addEventListener("click", async (e) => {
            e.preventDefault();
            document.getElementById("submit-btn").disabled = true;
            document.getElementById("message").textContent = "";

            const { error, paymentIntent } = await stripe.confirmCardPayment(clientSecret, {
                elements,
                confirmParams: {
                    return_url: "{{ route('payments.success', ['deposit' => $deposit->id]) }}"
                }
            });

            if (error) {
                document.getElementById("message").innerHTML = `<div class="error">${error.message}</div>`;
                document.getElementById("submit-btn").disabled = false;
            } else {
                if (paymentIntent && paymentIntent.status === "requires_capture") {
                    document.getElementById("message").innerHTML =
                        `<div class="success">Hold authorised successfully!</div>`;
                }
            }
        });

        init();
    </script>
</body>
</html>
