@extends('layouts.public')

@section('content')
  <h1>Pay a one-off charge</h1>

  <p><strong>Amount:</strong> {{ money_format_nzd($p->amount_cents) }}</p>
  @if($p->reason)
    <p><strong>Reason:</strong> {{ $p->reason }}</p>
  @endif

  @if($attachments->count())
    <p><strong>Supporting evidence:</strong></p>
    <ul>
      @foreach($attachments as $a)
        <li><a href="{{ $a['url'] }}" target="_blank" rel="noopener">{{ $a['name'] }}</a></li>
      @endforeach
    </ul>
  @endif

  @php
    $checkoutId = data_get($p->gateway_meta, 'checkout_session');
  @endphp

  @if($p->status === 'succeeded')
    <p>Payment already completed. Thank you!</p>
  @elseif($checkoutId)
    <a class="btn btn-primary" href="{{ \Stripe\Checkout\Session::retrieve($checkoutId, ['api_key' => config('services.stripe.secret')])->url }}">Pay securely</a>
  @else
    <p>Payment link not ready yet. Please try again soon or contact support.</p>
  @endif
@endsection
