<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>@yield('title','Payment')</title>

  {{-- If you compile assets with Vite, keep this and remove the CDN --}}
  @vite(['resources/css/app.css','resources/js/app.js'])

  {{-- Fallback Tailwind CDN for the public portal (remove if not needed) --}}
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-slate-50 text-slate-900 antialiased">
  <header class="bg-white border-b">
    <div class="mx-auto max-w-6xl px-4 py-4 flex items-center gap-3">
      <div class="h-9 w-9 rounded-xl bg-indigo-600/10 grid place-items-center">
        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 24 24" fill="currentColor"><path d="M12 2a10 10 0 100 20 10 10 0 000-20Zm1 5v5l4 2-.75 1.86L11 13V7h2Z"/></svg>
      </div>
      <div class="font-semibold">Dream Drives Payments</div>
      <div class="ml-auto flex items-center gap-2 text-xs text-slate-500">
        <span class="inline-flex items-center gap-1">
          <svg class="h-4 w-4" viewBox="0 0 24 24" fill="currentColor"><path d="M12 1 3 5v6c0 5.55 3.84 10.74 9 12 5.16-1.26 9-6.45 9-12V5l-9-4Zm0 2.18 7 3.11v4.71c0 4.59-3 8.93-7 10.2-4-1.27-7-5.61-7-10.2V6.29l7-3.11ZM11 7h2v6h-2V7Zm0 8h2v2h-2v-2Z"/></svg>
          PCI DSS • 3-D Secure • TLS 1.2+
        </span>
      </div>
    </div>
  </header>

  <main class="mx-auto max-w-6xl px-4 py-10">
    @yield('content')
  </main>

  <footer class="mx-auto max-w-6xl px-4 py-8 text-xs text-slate-500">
    © {{ now()->year }} Dream Drives. All rights reserved.
  </footer>

  @stack('scripts')
</body>
</html>
