@php($title = 'Login to your portal')

@extends('layouts.app')

@section('content')
<div class="max-w-md mx-auto my-16 p-6 rounded-2xl shadow">
  <h1 class="text-2xl font-semibold mb-6">Sign in</h1>

  @if (session('status'))
    <div class="mb-3 text-sm text-emerald-700">{{ session('status') }}</div>
  @endif

  @if ($errors->any())
    <div class="mb-3 text-sm text-red-600">
      @foreach ($errors->all() as $e) <div>{{ $e }}</div> @endforeach
    </div>
  @endif

  <form method="POST" action="{{ route('portal.login.classic.attempt') }}">
    @csrf
    <label class="block mb-3">
      <span class="text-sm">Email</span>
      <input class="w-full border rounded px-3 py-2" type="email" name="email" value="{{ old('email') }}" required autofocus>
    </label>

    <label class="block mb-4">
      <span class="text-sm">Password</span>
      <input class="w-full border rounded px-3 py-2" type="password" name="password">
    </label>

    <label class="inline-flex items-center mb-6">
      <input type="checkbox" name="remember" class="mr-2">
      <span class="text-sm">Remember me</span>
    </label>

    <button class="w-full px-4 py-2 rounded bg-black text-white" type="submit">
      Sign in
    </button>

    {{-- Optional: email-only “magic link / code” input for your future flow --}}
    {{-- <input type="hidden" name="reference" value=""> --}}
  </form>
</div>
@endsection
