@extends('portal.layout')
@section('title','Review details')

@php
  /** @var \App\Models\Job $job */
  $payUrl = route('portal.pay.show.job', ['job' => $job->id]);
@endphp

@section('content')
  <div class="mb-6">
    <ol class="flex items-center gap-3 text-sm">
      <li class="flex items-center gap-2 font-medium text-indigo-700">
        <span class="h-6 w-6 rounded-full bg-indigo-600 text-white grid place-items-center">1</span>
        Details
      </li>
      <span class="h-px w-10 bg-slate-300"></span>
      <li class="flex items-center gap-2 text-slate-500">
        <span class="h-6 w-6 rounded-full bg-slate-200 grid place-items-center">2</span>
        Pay
      </li>
      <span class="h-px w-10 bg-slate-300"></span>
      <li class="flex items-center gap-2 text-slate-500">
        <span class="h-6 w-6 rounded-full bg-slate-200 grid place-items-center">3</span>
        Complete
      </li>
    </ol>
  </div>

  <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
    <div class="lg:col-span-2 rounded-2xl border bg-white p-6 shadow-sm">
      <h1 class="text-xl font-semibold mb-4">Review your booking</h1>
      {{-- put your booking details here (dates, car, options, pricing breakdown) --}}
    </div>
    <aside class="space-y-4">
      <a href="{{ $payUrl }}" class="block text-center rounded-xl bg-indigo-600 px-5 py-3 font-medium text-white shadow-sm hover:bg-indigo-700">
        Continue to payment
      </a>
    </aside>
  </div>
@endsection
