<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Pay deposit / balance</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <style>
    body{font-family:system-ui,-apple-system,Segoe UI,Roboto,Helvetica,Arial,sans-serif;margin:0;background:#0b0d12;color:#e5e7eb}
    .wrap{max-width:680px;margin:4rem auto;padding:2rem;background:#111827;border-radius:12px;border:1px solid #1f2937}
    h1{margin:0 0 1rem}
    .row{display:flex;gap:1rem;flex-wrap:wrap}
    .card{flex:1 1 240px;background:#0f172a;border:1px solid #1e293b;border-radius:10px;padding:1rem}
    .btn{display:inline-block;padding:0.8rem 1.2rem;background:#2563eb;color:#fff;border-radius:8px;text-decoration:none;border:none;cursor:pointer}
    .btn:disabled{opacity:.5;cursor:not-allowed}
    .muted{color:#9ca3af}
  </style>
</head>
<body>
  <div class="wrap">
    <h1>Payment</h1>

    <div class="row">
      <div class="card">
        <div class="muted">Reference</div>
        <div><strong>{{ $payment->job->external_reference ?? $payment->id }}</strong></div>
      </div>
      <div class="card">
        <div class="muted">Amount</div>
        <div><strong>NZ$ {{ number_format(($payment->amount_cents ?? 0)/100, 2) }}</strong></div>
      </div>
      <div class="card">
        <div class="muted">Status</div>
        <div><strong>{{ ucfirst($payment->status ?? 'pending') }}</strong></div>
      </div>
    </div>

    @if(($payment->status ?? '') === 'succeeded')
      <p style="margin-top:1.5rem">Thanks — this payment is already completed.</p>
      <p><a class="btn" href="{{ route('payments.public.thanks', ['token' => $payment->portal_token]) }}">Continue</a></p>
    @else
      <p style="margin-top:1.5rem">Click to proceed with payment.</p>
      <!-- Your routes already allow POST /pay/{token}/intent without CSRF -->
      <form method="post" action="{{ route('payments.public.intent', ['token' => $payment->portal_token]) }}">
        @csrf
        <button class="btn" type="submit">Pay now</button>
      </form>
    @endif

    <p class="muted" style="margin-top:1.5rem">
      Token: {{ $payment->portal_token }}
    </p>
  </div>
</body>
</html>
