@extends('layouts.app')

@section('content')
<div class="max-w-xl mx-auto py-8">
    <h1 class="text-2xl font-bold mb-4">Book your Dream Drives car</h1>

    @if (session('error'))
        <div class="mb-4 text-red-600">
            {{ session('error') }}
        </div>
    @endif

    <form method="POST" action="{{ route('book.dreamdrives.store') }}" class="space-y-4">
        @csrf

        <div>
            <label class="block text-sm font-medium mb-1">Vehicle</label>
            <select name="vehicle_id" class="w-full border rounded px-3 py-2">
                <option value="">Select a vehicle</option>
                @foreach ($vehicles as $vehicle)
                    <option value="{{ $vehicle->id }}" @selected(old('vehicle_id') == $vehicle->id)>
                        {{ $vehicle->display_name ?? $vehicle->name ?? "Vehicle #{$vehicle->id}" }}
                    </option>
                @endforeach
            </select>
            @error('vehicle_id') <p class="text-xs text-red-600">{{ $message }}</p> @enderror
        </div>

        <div>
            <label class="block text-sm font-medium mb-1">Pickup date & time</label>
            <input type="datetime-local" name="pickup_at" value="{{ old('pickup_at') }}"
                   class="w-full border rounded px-3 py-2">
            @error('pickup_at') <p class="text-xs text-red-600">{{ $message }}</p> @enderror
        </div>

        <div>
            <label class="block text-sm font-medium mb-1">Return date & time</label>
            <input type="datetime-local" name="return_at" value="{{ old('return_at') }}"
                   class="w-full border rounded px-3 py-2">
            @error('return_at') <p class="text-xs text-red-600">{{ $message }}</p> @enderror
        </div>

        <hr class="my-4">

        <div>
            <label class="block text-sm font-medium mb-1">Name</label>
            <input type="text" name="customer_name" value="{{ old('customer_name') }}"
                   class="w-full border rounded px-3 py-2">
            @error('customer_name') <p class="text-xs text-red-600">{{ $message }}</p> @enderror
        </div>

        <div>
            <label class="block text-sm font-medium mb-1">Email</label>
            <input type="email" name="customer_email" value="{{ old('customer_email') }}"
                   class="w-full border rounded px-3 py-2">
            @error('customer_email') <p class="text-xs text-red-600">{{ $message }}</p> @enderror
        </div>

        <div>
            <label class="block text-sm font-medium mb-1">Phone</label>
            <input type="text" name="customer_phone" value="{{ old('customer_phone') }}"
                   class="w-full border rounded px-3 py-2">
            @error('customer_phone') <p class="text-xs text-red-600">{{ $message }}</p> @enderror
        </div>

        <div>
            <label class="block text-sm font-medium mb-1">Notes (optional)</label>
            <textarea name="notes" rows="3" class="w-full border rounded px-3 py-2">{{ old('notes') }}</textarea>
            @error('notes') <p class="text-xs text-red-600">{{ $message }}</p> @enderror
        </div>

        <button type="submit" class="mt-4 inline-flex items-center px-4 py-2 bg-blue-600 text-white rounded">
            Submit booking
        </button>
    </form>
</div>
@endsection
