@extends('layouts.app')

@section('title', 'Booking received')

@section('content')
    <div class="card">
        <h1 style="font-size: 2rem; margin-top: 0; margin-bottom: 1rem;">
            Thanks for your booking!
        </h1>

        @if ($booking)
            <p>
                We’ve received your booking
                <strong>{{ $booking->reference }}</strong>.
            </p>

            <p class="muted">
                Pickup: {{ optional($booking->pickup_at)->format('d M Y, H:i') }}<br>
                Return: {{ optional($booking->return_at)->format('d M Y, H:i') }}<br>
                @if (! empty($booking->vehicle_name))
                    Vehicle: {{ $booking->vehicle_name }}
                @endif
            </p>
        @else
            <p>
                We’ve received your booking. Your reference is:
                <strong>{{ $reference ?? 'N/A' }}</strong>.
            </p>
        @endif

        <p style="margin-top: 1.5rem;">
            We’ll email you a confirmation shortly.  
            If you have any questions, just reply to the email or contact us.
        </p>

        <p style="margin-top: 2rem;">
            <a href="{{ url('/') }}" class="btn">Back to site</a>
        </p>
    </div>
@endsection
