<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Holds\Api\V1\HoldsApiController;
use App\Domain\Holds\Services\Contracts\HoldGateway;

// Register only if the controller exists AND the HoldGateway binding is available.
if (
    class_exists(HoldsApiController::class)
    && app()->bound(HoldGateway::class)
) {
    // This file applies its own prefix/middleware so RouteServiceProvider
    // should NOT wrap it in another /api group.
    Route::prefix('api/v1')
        ->middleware('auth.apikey')
        ->group(function () {
            Route::post('/holds', [HoldsApiController::class, 'store'])
                ->name('api.v1.holds.store');

            Route::get('/holds/{id}', [HoldsApiController::class, 'show'])
                ->where('id', '[A-Za-z0-9\-_]+')
                ->name('api.v1.holds.show');

            Route::patch('/holds/{id}/capture', [HoldsApiController::class, 'capture'])
                ->where('id', '[A-Za-z0-9\-_]+')
                ->name('api.v1.holds.capture');

            Route::patch('/holds/{id}/release', [HoldsApiController::class, 'release'])
                ->where('id', '[A-Za-z0-9\-_]+')
                ->name('api.v1.holds.release');
        });
}
