<?php
    /** @var \App\Models\Owner $owner */
    /** @var \Illuminate\Support\Carbon $fromDate */
    /** @var \Illuminate\Support\Carbon $toDate */
    /** @var array $totals */
    /** @var int $payoutAmountCents */
    /** @var array|null $previewTotals */
    /** @var \Illuminate\Support\Carbon|null $previewPayoutDate */
    /** @var \Illuminate\Support\Collection|null $previewJobs */
    /** @var \Illuminate\Support\Collection|null $vehicles */
    /** @var string $statementId */

    $earnings    = $totals['earnings_cents']    ?? 0;
    $costs       = $totals['costs_cents']       ?? 0;
    $payouts     = $totals['payouts_cents']     ?? 0;
    $adjustments = $totals['adjustments_cents'] ?? 0;
    $balance     = $totals['balance_cents']     ?? 0;

    $fmt = fn (int $cents) => '$' . number_format($cents / 100, 2);

    // Normalise preview data so this view never explodes
    $previewTotals     = $previewTotals     ?? ['owner_total_cents' => 0, 'month_label' => null, 'per_vehicle_cents' => []];
    $previewPayoutDate = $previewPayoutDate ?? now()->copy()->day(10);
    $previewJobs       = isset($previewJobs) ? $previewJobs : collect();

    $previewOwnerTotal = $previewTotals['owner_total_cents'] ?? 0;
    $previewMonthLabel = $previewTotals['month_label'] ?? $previewPayoutDate->format('F Y');
    $previewPerVehicle = $previewTotals['per_vehicle_cents'] ?? [];
?>

<p>Hi <?php echo e($owner->legal_name ?? $owner->name); ?>,</p>

<p>
    Please find attached your owner statement for
    <strong><?php echo e($fromDate->toFormattedDateString()); ?></strong>
    to
    <strong><?php echo e($toDate->toFormattedDateString()); ?></strong>.
</p>

<p>
    <strong>Earnings (your share)</strong> <?php echo e($fmt($earnings)); ?><br>
    <strong>Adjustments</strong> <?php echo e($fmt($adjustments)); ?><br>
    <strong>Costs</strong> <?php echo e($fmt($costs)); ?><br>
    <strong>Payouts</strong> <?php echo e($fmt($payouts)); ?><br>
    <strong>Balance</strong> <?php echo e($fmt($balance)); ?>

</p>

<?php if($payoutAmountCents !== 0): ?>
    <p>
        We’ve paid
        <strong><?php echo e($fmt($payoutAmountCents)); ?></strong>
        to your nominated bank account today.
    </p>
<?php endif; ?>

<?php if($previewOwnerTotal > 0): ?>
    <hr>
    <p>
        <strong>Looking ahead – next payout</strong><br>
        Estimated owner share for bookings ending in
        <strong><?php echo e($previewMonthLabel); ?></strong> is
        <strong><?php echo e($fmt($previewOwnerTotal)); ?></strong>.
        These are expected to be paid on
        <strong><?php echo e($previewPayoutDate->toFormattedDateString()); ?></strong>,
        according to our payout schedule (10th of each month for the previous month’s completed bookings).
    </p>

    <?php if(!empty($previewPerVehicle)): ?>
        <p>
            <strong>By vehicle:</strong><br>
            <?php $__currentLoopData = $previewPerVehicle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vehicleName => $ownerCents): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                • <?php echo e($vehicleName); ?> – <?php echo e($fmt($ownerCents)); ?><br>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </p>
    <?php endif; ?>
<?php endif; ?>

<?php if($previewJobs->isNotEmpty()): ?>
    <hr>
    <p>
        <strong>Your vehicle is booked on:</strong><br>
        <?php $__currentLoopData = $previewJobs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $job): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                $start = \Carbon\Carbon::parse($job->start_at)->toFormattedDateString();
                $end   = \Carbon\Carbon::parse($job->end_at)->toFormattedDateString();
            ?>
            • <?php echo e($job->vehicle?->name); ?>:
              <?php echo e($start); ?> – <?php echo e($end); ?><br>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </p>
<?php endif; ?>

<p>
    If you have any questions about this statement, just reply to this email and we’ll be happy to help.
</p>

<p>
    Thanks,<br>
    Dream Drives
</p>
<?php /**PATH /home/dreamdrivesco/apps/holds/resources/views/mail/owner_statement.blade.php ENDPATH**/ ?>