<?php
    /** Expected: $job, $payment. Optional: $brand, $amountCents, $currency, $bookingRef, $startAt, $endAt, $viewUrl */

    // Brand / logo (keeps parity with the request template)
    $brandName = $brand->short_name ?? 'Dream Drives';
    $logo      = $brand->email_logo_url ?? null;

    // Currency + formatter
    $ccy = strtoupper($currency ?? $payment->currency ?? $job->currency ?? 'NZD');
    $sym = [
        'NZD' => 'NZ$', 'AUD' => 'A$', 'USD' => '$', 'GBP' => '£', 'EUR' => '€', 'CAD' => 'C$',
    ][$ccy] ?? $ccy;

    $fmt = fn ($c) => $sym . number_format(((int) $c) / 100, 2);

    // Amount (prefer explicit amountCents if passed)
    $amount = isset($amountCents)
        ? (int) $amountCents
        : (int) ($payment->amount_cents ?? $payment->amount ?? 0);

    // Person/name
    $firstName = trim(explode(' ', $job->customer_name ?? 'there')[0] ?? 'there');

    // Times / dates
    $formatDt = function ($v, $fmt = 'D d M Y, h:ia') {
        try {
            if ($v instanceof \Illuminate\Support\Carbon || $v instanceof \Carbon\Carbon) return $v->format($fmt);
            return \Carbon\Carbon::parse($v)->format($fmt);
        } catch (\Throwable $e) { return null; }
    };

    $paidAt   = $formatDt($payment->created_at ?? now());
    $startTxt = isset($startAt) ? $formatDt($startAt, 'D d M Y, H:i') : ($job->start_at ? $formatDt($job->start_at, 'D d M Y, H:i') : null);
    $endTxt   = isset($endAt)   ? $formatDt($endAt,   'D d M Y, H:i') : ($job->end_at   ? $formatDt($job->end_at,   'D d M Y, H:i') : null);

    // References
    $ref      = $bookingRef ?? $job->external_reference ?? null;
    $charge   = $payment->stripe_charge ?? $payment->stripe_charge_id ?? null;
    $pi       = $payment->stripe_payment_intent ?? $payment->stripe_payment_intent_id ?? null;
?>

<?php $__env->startComponent('mail::message'); ?>
<?php if($logo): ?>
<p style="text-align:center;margin:0 0 12px">
  <img src="<?php echo e($logo); ?>" alt="<?php echo e($brandName); ?>" style="max-height:42px">
</p>
<?php endif; ?>

# Payment receipt

Hi <?php echo e($firstName); ?>,

We’ve received your payment for **Job #<?php echo e($job->id); ?>** (<?php echo e($brandName); ?>).

**Amount paid:** <?php echo e($fmt($amount)); ?> <span style="color:#6b7280">(<?php echo e($ccy); ?>)</span>  
**Paid at:** <?php echo e($paidAt); ?>


---

**Receipt summary**
- Job: **#<?php echo e($job->id); ?>**
<?php if(isset($ref)): ?>
- Reservation reference: **<?php echo e($ref); ?>**
<?php endif; ?>
<?php if($startTxt || $endTxt): ?>
- Dates: <?php echo e($startTxt); ?> → <?php echo e($endTxt); ?>

<?php endif; ?>
<?php if(!empty($job->customer_name)): ?>
- Customer: <?php echo e($job->customer_name); ?>

<?php endif; ?>
<?php if(!empty($job->customer_email)): ?>
- Email: <a href="mailto:<?php echo e($job->customer_email); ?>"><?php echo e($job->customer_email); ?></a>
<?php endif; ?>
<?php if(!empty($job->customer_phone)): ?>
- Phone: <?php echo e($job->customer_phone); ?>

<?php endif; ?>
<?php if(isset($charge)): ?>
- Stripe charge: `<?php echo e($charge); ?>`
<?php endif; ?>
<?php if(isset($pi)): ?>
- Payment intent: `<?php echo e($pi); ?>`
<?php endif; ?>

<?php if(isset($viewUrl)): ?>
<?php $__env->startComponent('mail::button', ['url' => $viewUrl]); ?>
View booking
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>

Thanks,  
**<?php echo e($brandName); ?>**

<small>This is an automated receipt. If you have questions, just reply to this email.  
If your booking includes a refundable security hold, it may show as “pending” and will be released per our policy.</small>
<?php echo $__env->renderComponent(); ?>
<?php /**PATH /home/dreamdrivesco/apps/holds/resources/views/mail/payment-receipt.blade.php ENDPATH**/ ?>